/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.index;

import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index;

public class CreateIndex
implements Statement {
    private Table table;
    private Index index;
    private List<String> tailParameters;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getTailParameters() {
        return this.tailParameters;
    }

    public void setTailParameters(List<String> list) {
        this.tailParameters = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ");
        if (this.index.getType() != null) {
            stringBuilder.append(this.index.getType());
            stringBuilder.append(" ");
        }
        stringBuilder.append("INDEX ");
        stringBuilder.append(this.index.getName());
        stringBuilder.append(" ON ");
        stringBuilder.append(this.table.getFullyQualifiedName());
        if (this.index.getUsing() != null) {
            stringBuilder.append(" USING ");
            stringBuilder.append(this.index.getUsing());
        }
        if (this.index.getColumnsNames() != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.index.getColumns().stream().map(index$ColumnParams -> index$ColumnParams.columnName + (index$ColumnParams.getParams() != null ? " " + String.join((CharSequence)" ", index$ColumnParams.getParams()) : "")).collect(Collectors.joining(", ")));
            stringBuilder.append(")");
            if (this.tailParameters != null) {
                for (String string : this.tailParameters) {
                    stringBuilder.append(" ").append(string);
                }
            }
        }
        return stringBuilder.toString();
    }

    public CreateIndex withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public CreateIndex withIndex(Index index) {
        this.setIndex(index);
        return this;
    }

    public CreateIndex withTailParameters(List<String> list) {
        this.setTailParameters(list);
        return this;
    }
}

