/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter$MOD_TYPE;
import com.datical.liquibase.ext.changelog.FormattedSqlChangelogRewriter;
import com.datical.liquibase.ext.changelog.JsonChangelogRewriter;
import com.datical.liquibase.ext.changelog.XMLChangelogRewriter;
import com.datical.liquibase.ext.changelog.YamlChangelogRewriter;
import liquibase.changelog.DatabaseChangeLog;

public class ChangelogRewriterFactory {
    private static ChangelogRewriterFactory factory;

    private ChangelogRewriterFactory() {
    }

    public static ChangelogRewriterFactory getInstance() {
        if (factory == null) {
            factory = new ChangelogRewriterFactory();
        }
        return factory;
    }

    public ChangelogRewriter createChangelogRewriter(String string, DatabaseChangeLog object, String string2, ChangelogRewriter$MOD_TYPE changelogRewriter$MOD_TYPE) {
        if (string.toLowerCase().endsWith(".xml")) {
            return new XMLChangelogRewriter(string, (DatabaseChangeLog)object, string2, changelogRewriter$MOD_TYPE);
        }
        if (string.toLowerCase().endsWith(".sql")) {
            if (!(object = new FormattedSqlChangelogRewriter(string, (DatabaseChangeLog)object, string2, changelogRewriter$MOD_TYPE)).supports(string)) {
                return null;
            }
            return object;
        }
        if (string.toLowerCase().endsWith(".json")) {
            return new JsonChangelogRewriter(string, (DatabaseChangeLog)object, changelogRewriter$MOD_TYPE);
        }
        if (string.toLowerCase().endsWith(".yml") || string.toLowerCase().endsWith(".yaml")) {
            return new YamlChangelogRewriter(string, (DatabaseChangeLog)object, changelogRewriter$MOD_TYPE);
        }
        return null;
    }
}

