/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter$KeyValuePair;
import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter$MOD_TYPE;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.util.StringUtil;

public class YamlChangelogRewriter
extends AbstractChangelogRewriter
implements ChangelogRewriter {
    public static final String CHANGES = "changes:";
    public static final String LABELS = "labels";
    public static final String CONTEXT = "context";
    public static final String CONTEXT_FILTER = "contextFilter";
    public static final String CHANGE_SET = "changeSet:";
    public static final String INCLUDE = "include:";
    public static final String INCLUDE_ALL = "includeAll:";
    public static final String FILE = "file: ";
    public static final String PATH = "path: ";
    public static final String LABELS_REPLACEMENT_STRING = "labels: ";
    public static final String CONTEXT_REPLACEMENT_STRING = "context: ";

    public YamlChangelogRewriter(String string, DatabaseChangeLog databaseChangeLog, ChangelogRewriter$MOD_TYPE changelogRewriter$MOD_TYPE) {
        super(string, databaseChangeLog, changelogRewriter$MOD_TYPE, null);
    }

    @Override
    public String handle(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.replace("\r\n", "\n").split("\n");
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string4 = null;
        String string5 = null;
        for (String string6 : stringArray) {
            if (string6.isEmpty()) {
                stringBuilder.append(string6);
                stringBuilder.append(System.lineSeparator());
                continue;
            }
            if (string6.contains(CHANGES) && bl2) {
                if (this.modType == ChangelogRewriter$MOD_TYPE.LABELS && !bl3) {
                    this.handleAddLabelsToYaml(stringBuilder, string2, string3, string6, string5);
                } else if (this.modType == ChangelogRewriter$MOD_TYPE.CONTEXTS && !bl4) {
                    this.handleAddContextsToYaml(stringBuilder, string2, string3, string6, string4);
                }
                bl2 = false;
                bl3 = false;
                bl4 = false;
            } else if (bl2) {
                ChangeSet changeSet;
                String[] stringArray2 = string6.split(":");
                AbstractChangelogRewriter$KeyValuePair abstractChangelogRewriter$KeyValuePair = this.parseKeyValuePair(stringArray2);
                if (abstractChangelogRewriter$KeyValuePair.key.equals("id")) {
                    string2 = abstractChangelogRewriter$KeyValuePair.value;
                } else if (abstractChangelogRewriter$KeyValuePair.key.equals("author")) {
                    string3 = abstractChangelogRewriter$KeyValuePair.value;
                } else if (this.modType == ChangelogRewriter$MOD_TYPE.LABELS && abstractChangelogRewriter$KeyValuePair.key.equals(LABELS)) {
                    changeSet = this.getChangeSet(string3, string2);
                    if (changeSet != null) {
                        string5 = string6;
                        if (changeSet.isIgnore()) {
                            String string7 = "Ignoring changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(string7);
                            bl2 = false;
                            bl3 = false;
                            string2 = null;
                            string3 = null;
                        } else {
                            if (stringArray2.length <= 1) continue;
                            string6 = this.rewriteLabelsYaml(string6, stringArray2[1], abstractChangelogRewriter$KeyValuePair.value, changeSet);
                            bl3 = true;
                        }
                    } else {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                    }
                } else if (this.modType == ChangelogRewriter$MOD_TYPE.CONTEXTS && (abstractChangelogRewriter$KeyValuePair.key.equals(CONTEXT) || abstractChangelogRewriter$KeyValuePair.key.equals(CONTEXT_FILTER))) {
                    changeSet = this.getChangeSet(string3, string2);
                    if (changeSet != null) {
                        string4 = string6;
                        if (changeSet.isIgnore()) {
                            String string8 = "Ignoring changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(string8);
                            bl2 = false;
                            bl4 = false;
                            string2 = null;
                            string3 = null;
                        } else {
                            if (stringArray2.length <= 1) continue;
                            string6 = this.rewriteContextsYaml(string6, stringArray2[1], abstractChangelogRewriter$KeyValuePair.value, changeSet);
                            bl4 = true;
                        }
                    } else {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                    }
                }
            } else if (string6.contains(CHANGE_SET)) {
                bl2 = true;
            }
            stringBuilder.append(string6);
            stringBuilder.append(System.lineSeparator());
        }
        this.handleIncludes(string);
        return stringBuilder.toString();
    }

    private void handleAddLabelsToYaml(StringBuilder stringBuilder, String string, String string2, String string3, String string4) {
        if (string4 == null) {
            this.addNewLabelsLineToYaml(stringBuilder, string, string2, string3);
            return;
        }
        this.addNewLabelsLineToYaml(stringBuilder, string, string2, string4);
    }

    private void handleAddContextsToYaml(StringBuilder stringBuilder, String string, String string2, String string3, String string4) {
        if (string4 == null) {
            this.addNewContextsLineToYaml(stringBuilder, string, string2, string3);
            return;
        }
        this.addNewContextsLineToYaml(stringBuilder, string, string2, string4);
    }

    private void addNewLabelsLineToYaml(StringBuilder stringBuilder, String string, String string2, String string3) {
        if ((string = this.getChangeSet(string2, string)) != null && StringUtil.isNotEmpty((String)string.getLabels().toString())) {
            string = string3.replace(CHANGES, LABELS_REPLACEMENT_STRING) + " \"" + string.getLabels() + "\"";
            stringBuilder.append(string);
            stringBuilder.append(System.lineSeparator());
        }
    }

    private void addNewContextsLineToYaml(StringBuilder stringBuilder, String string, String string2, String string3) {
        if ((string = this.getChangeSet(string2, string)) != null && StringUtil.isNotEmpty((String)(string = this.createContextStringForFile((ChangeSet)string)))) {
            string = string3.replace(CHANGES, CONTEXT_REPLACEMENT_STRING) + " \"" + string + "\"";
            stringBuilder.append(string);
            stringBuilder.append(System.lineSeparator());
        }
    }

    private String rewriteContextsYaml(String string, String string2, String string3, ChangeSet object) {
        if (object != null && object.getContextFilter() != null) {
            object = this.createContextStringForFile((ChangeSet)object);
            string = this.replaceIfModified(string, string2, string3, (String)object);
        }
        return string;
    }

    private String rewriteLabelsYaml(String string, String string2, String string3, ChangeSet object) {
        if (object != null && object.getLabels() != null) {
            object = object.getLabels().toString();
            string = this.replaceIfModified(string, string2, string3, (String)object);
        }
        return string;
    }

    private String replaceIfModified(String string, String string2, String string3, String string4) {
        if (StringUtil.isNotEmpty((String)string4) && !string3.equals(string4)) {
            string = string2.startsWith("\"") && string2.endsWith("\"") ? string.replace(":".concat(String.valueOf(string2)), ": \"" + string4 + "\",") : string.replace(":".concat(String.valueOf(string2)), ": \"" + string4 + "\"");
        }
        return string;
    }
}

