/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.InternalFormattedDiffCommandStep;
import com.datical.liquibase.ext.config.DriftConfiguration;
import com.datical.liquibase.ext.diff.FormattedChangeObject;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.diff.FormattedDiffObject;
import com.datical.liquibase.ext.reports.DatabaseObjectReportValue;
import com.datical.liquibase.ext.reports.DriftReport;
import com.datical.liquibase.ext.reports.DriftReportMode;
import com.datical.liquibase.ext.reports.DriftReportParameters;
import com.datical.liquibase.ext.reports.TextDriftReport;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import java.awt.Desktop;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.providers.ReferenceDatabase;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.util.NetUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class DriftReportCommandStep
extends AbstractCommandStep {
    public static String[] COMMAND_NAME = new String[]{"driftReport"};
    public static final String DEFAULT_REPORT_NAME_DATE_FORMAT = "dd-MMM-yyyy-HHmmss";
    public static final CommandArgumentDefinition<Boolean> OPEN_REPORT = new CommandBuilder((String[][])new String[][]{COMMAND_NAME}).argument("openReport", Boolean.class).description("Open the Diff Report in your default browser.").defaultValue((Object)Boolean.FALSE).hidden().optional().build();

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(DiffResult.class, FormattedDiffModel.class, Database.class, ReferenceDatabase.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (Arrays.equals(commandDefinition.getName(), COMMAND_NAME)) {
            commandDefinition.setHidden(true);
        }
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        if (!((Boolean)DriftConfiguration.REPORT_ENABLED.getCurrentValue()).booleanValue()) {
            return;
        }
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        String string = (String)DriftConfiguration.REPORT_PATH.getCurrentValue();
        DriftConfiguration.REPORT_FORMAT.getCurrentValue();
        DriftReportMode driftReportMode = (DriftReportMode)((Object)DriftConfiguration.REPORT_MODE.getCurrentValue());
        Boolean bl2 = (Boolean)object.getArgumentValue(OPEN_REPORT);
        String string2 = (String)DriftConfiguration.REPORT_NAME.getCurrentValue();
        LocalDateTime localDateTime = LocalDateTime.now();
        if (string2.equals(DriftConfiguration.DRIFT_REPORT_NAME_EXAMPLE)) {
            string2 = String.format("report-%s", this.buildDriftReportDateFormat(localDateTime));
        }
        Scope.getCurrentScope().getUI().sendMessage("Generating drift report...");
        localDateTime = (Database)object.getDependency(Database.class);
        Database database = (Database)object.getDependency(ReferenceDatabase.class);
        DiffResult diffResult = (DiffResult)commandResultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        String string3 = NetUtil.getLocalHostName();
        String string4 = EnvironmentUtils.getSystemUsername();
        Integer n2 = (Integer)commandResultsBuilder.getResult("driftExitCode");
        boolean bl3 = n2 != null && n2 != 0;
        Object object2 = new TextDriftReport(diffResult);
        List<DatabaseObjectReportValue> list = object2.getMissingValues();
        List<DatabaseObjectReportValue> list2 = object2.getUnexpectedValues();
        object2 = object2.getChangedValues();
        int n3 = diffResult.getMissingObjects().size();
        int n4 = diffResult.getUnexpectedObjects().size();
        int n5 = diffResult.getChangedObjects().size();
        Object object3 = this.buildSerializer();
        object = (FormattedDiffModel)((Object)object.getDependency(FormattedDiffModel.class));
        if (object == null) {
            object = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        }
        String string5 = this.dumpJson(((FormattedDiffModel)((Object)object)).getMissingObjects(), (Yaml)object3);
        String string6 = this.dumpJson(((FormattedDiffModel)((Object)object)).getUnexpectedObjects(), (Yaml)object3);
        object = this.dumpJson(((FormattedDiffModel)((Object)object)).getChangedObjects(), (Yaml)object3);
        object3 = this.getDisplayArgs((String[])Scope.getCurrentScope().get("commandArguments", String[].class));
        object = new DriftReportParameters(string2, localDateTime.getConnection().getURL(), database.getConnection().getURL(), string4, string3, list, list2, (List<DatabaseObjectReportValue>)object2, string5, string6, (String)object, String.valueOf(n3), String.valueOf(n4), String.valueOf(n5), driftReportMode == DriftReportMode.ALL || driftReportMode == DriftReportMode.MISSING, driftReportMode == DriftReportMode.ALL || driftReportMode == DriftReportMode.UNEXPECTED, driftReportMode == DriftReportMode.ALL || driftReportMode == DriftReportMode.CHANGED, string, (String)object3, driftReportMode.name());
        object = new DriftReport(string2, string, (DriftReportParameters)object);
        ((DriftReport)object).generateReport();
        if (bl2.booleanValue()) {
            this.openInBrowser(((DriftReport)object).getFullPath());
        }
        if (bl3) {
            throw commandResultsBuilder.commandFailed(String.format("ERROR: Liquibase detected drift of %d missing, %d changed, and %d unexpected objects between target '%s' and reference '%s'.%nFor additional details, inspect the output, set --format=JSON, or learn more at https://docs.liquibase.com/drift-reports.%nDiff command exited with error code %d", diffResult.getMissingObjects().size(), diffResult.getChangedObjects().size(), diffResult.getUnexpectedObjects().size(), localDateTime.getConnection().getURL(), database.getConnection().getURL(), n2), n2.intValue(), true);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int n2 = super.getOrder(commandDefinition);
        if (n2 < 0 && !commandDefinition.getName()[0].equals(DiffCommandStep.COMMAND_NAME[0])) {
            return n2;
        }
        return 1100;
    }

    private Yaml buildSerializer() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setSplitLines(false);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        YamlSerializer.LiquibaseRepresenter liquibaseRepresenter = new YamlSerializer.LiquibaseRepresenter(dumperOptions);
        liquibaseRepresenter.addClassTag(FormattedDiffObject.class, Tag.MAP);
        liquibaseRepresenter.addClassTag(FormattedChangeObject.class, Tag.MAP);
        return new Yaml((BaseConstructor)new SafeConstructor(YamlParser.createLoaderOptions()), (Representer)liquibaseRepresenter, dumperOptions, (Resolver)new YamlSerializer.LiquibaseResolver());
    }

    private String dumpJson(Object object, Yaml yaml) {
        return yaml.dumpAs(object, Tag.MAP, DumperOptions.FlowStyle.FLOW).replaceAll("!!null \"null\"", "\"null\"").replaceAll("!!map ", "").replaceAll("!!com.datical.liquibase.\\S+ (.*)", "$1").replaceAll("!!int ", "").replaceAll("\\[\\s+]", "[]");
    }

    private String buildDriftReportDateFormat(LocalDateTime localDateTime) {
        return DateTimeFormatter.ofPattern(DEFAULT_REPORT_NAME_DATE_FORMAT).format(localDateTime);
    }

    private void openInBrowser(Path path) {
        try {
            Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                desktop.open(path.toFile());
            }
            return;
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not open report in browser!", (Throwable)exception);
            return;
        }
    }

    public String getDisplayArgs(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object object = stringArray[i2];
            if (object.toLowerCase().contains("url")) {
                object = object.replaceFirst("(.*?)=(.*)", "$1 $2").split(" ");
                arrayList.add(object[0]);
                if ((object = ((String[])object).length > 1 ? object[1] : null) == null) {
                    object = stringArray[i2 + 1];
                    ++i2;
                }
                if (object != null) {
                    object = JdbcConnection.sanitizeUrl((String)object);
                    arrayList.add(object);
                    continue;
                }
                arrayList.add(" ");
                continue;
            }
            if (object.toLowerCase().contains("password") || object.toLowerCase().contains("licensekey") || object.toLowerCase().contains("license-key")) {
                object = object.replaceFirst("(.*?)=(.*)", "$1 $2").split(" ");
                arrayList.add(object[0]);
                arrayList.add("*****");
                if (((String[])object).length != 1) continue;
                ++i2;
                continue;
            }
            arrayList.add(object);
        }
        return StringUtil.join(arrayList, (String)" ");
    }
}

