/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleRanChangeSetFilter;
import com.datical.liquibase.ext.command.AbstractRollbackOneCommand;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;

public class RollbackOneChangesetCommandStep
extends AbstractRollbackOneCommand {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    private static final ResourceBundle coreBundle;
    public static final CommandArgumentDefinition<Boolean> SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one changeset from the database"));
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Object object = commandResultsBuilder.getCommandScope();
        String string = (String)object.getArgumentValue(CHANGESET_ID_ARG);
        String string2 = (String)object.getArgumentValue(CHANGESET_AUTHOR_ARG);
        String string3 = (String)object.getArgumentValue(CHANGESET_PATH_ARG);
        String string4 = (String)object.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)object.getDependency(ChangeLogParameters.class);
        Contexts contexts = changeLogParameters.getContexts();
        LabelExpression labelExpression = changeLogParameters.getLabels();
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)object.getDependency(DatabaseChangeLog.class);
        Database database = (Database)object.getDependency(Database.class);
        Object object2 = (Boolean)object.getArgumentValue(FORCE_ARG);
        boolean bl2 = (Boolean)object.getArgumentValue(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK);
        object = (ChangeExecListener)object.getDependency(ChangeExecListener.class);
        if (string == null || string2 == null || string3 == null) {
            throw new CommandValidationException(coreBundle.getString("id.author.path.required"));
        }
        if (object2 == null || !((Boolean)object2).booleanValue()) {
            object2 = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException((String)object2, Level.WARNING);
        }
        Scope.getCurrentScope().addMdcValue("rollbackScript", string4);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", database.getConnection().getURL());
        Scope.getCurrentScope().addMdcValue("rollbackOneChangesetForce", String.valueOf(object2));
        object2 = null;
        try {
            databaseChangeLog.validate(database, contexts, labelExpression);
            List list = database.getRanChangeSetList();
            object2 = new SingleRanChangeSetFilter(string, string2, string3, list, databaseChangeLog);
            if (((SingleRanChangeSetFilter)object2).isEmpty()) {
                throw new LiquibaseException(this.buildNoChangesetFoundException((SingleRanChangeSetFilter)object2, string3, string, string2));
            }
            list = this.createChangeLogIterator(list, (ChangeSetFilter)object2, databaseChangeLog, contexts, labelExpression, database);
            if (string4 == null) {
                ArrayList<ChangesetsRolledback.ChangeSet> arrayList = new ArrayList<ChangesetsRolledback.ChangeSet>();
                list.run((ChangeSetVisitor)this.createRollbackVisitor(arrayList, database, (ChangeExecListener)object), new RuntimeEnvironment(database, contexts, labelExpression));
                if (bl2) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback(arrayList), false);
                }
                commandResultsBuilder.addResult("processedChangesets", arrayList);
            } else {
                ChangeSet changeSet = ((SingleRanChangeSetFilter)object2).getMatchingChangeSet();
                this.executeRollbackScript(string4, changeSet, databaseChangeLog, changeLogParameters, database, (ChangeExecListener)object);
                this.removeRunStatus((ChangeLogIterator)list, contexts, labelExpression, database);
                object = Collections.singletonList(ChangesetsRolledback.ChangeSet.fromChangeSet((ChangeSet)changeSet));
                if (bl2) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback((List)object));
                }
                commandResultsBuilder.addResult("processedChangesets", object);
                logger.info("Executed rollback script ".concat(String.valueOf(string4)));
            }
            this.logSuccess(databaseChangeLog);
        }
        catch (LiquibaseException liquibaseException) {
            this.handleRollbackError((Exception)((Object)liquibaseException), (SingleRanChangeSetFilter)object2, string3, string, string2);
        }
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-changeset executed for " + database.getConnection().getConnectionUserName() + "@" + database.getConnection().getURL());
    }

    protected String getChangeSetString(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    private void executeRollbackScript(String string, ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, ChangeLogParameters changeLogParameters, Database database, ChangeExecListener changeExecListener) {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        String string2 = this.getChangeSetString(changeSet);
        string = this.getRollbackScriptContents(string, executor.toString(), changeLogParameters, databaseChangeLog);
        changeLogParameters = this.buildRawSQLChange(string);
        boolean bl2 = changeExecListener != null;
        try {
            if (bl2) {
                changeExecListener.willRollback(changeSet, databaseChangeLog, database);
            }
            Scope.getCurrentScope().getUI().sendMessage("Rolling Back Changeset:".concat(String.valueOf(string2)));
            executor.execute((Change)changeLogParameters);
            if (bl2) {
                changeExecListener.rolledBack(changeSet, databaseChangeLog, database);
            }
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error executing rollback script: " + databaseException.getMessage());
            if (bl2) {
                changeExecListener.rollbackFailed(changeSet, databaseChangeLog, database, (Exception)((Object)databaseException));
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + string2 + "':\n" + databaseException.getMessage(), (Throwable)databaseException);
        }
        database.commit();
        if (string.length() == 0) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from the DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    private String buildNoChangesetFoundException(SingleRanChangeSetFilter singleRanChangeSetFilter, String string, String string2, String string3) {
        String string4 = "rollback-one-changeset";
        string = string + "::" + string2 + "::" + string3;
        string = "\n\nWARNING:  The command '" + string4 + "' failed because the targeted changeset\n'" + string + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.\nPlease check your details and try again.\n";
        if (singleRanChangeSetFilter.getMatchingIdChangeSet() != null) {
            string = string + "\nNOTE:  A changeset with this ID was located.\n";
        }
        return string + "No rollback was performed.";
    }

    private void handleRollbackError(Exception exception, SingleRanChangeSetFilter object, String object2, String string, String object3) {
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        object = object != null && !((SingleRanChangeSetFilter)object).isEmpty() ? this.getChangeSetString(((SingleRanChangeSetFilter)object).getMatchingChangeSet()) : (String)object2 + "::" + string + "::" + (String)object3;
        object2 = exception.getCause();
        string = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
        object3 = null;
        try {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            object3 = throwable;
            throw throwable2;
        }
        finally {
            if (string != null) {
                if (object3 != null) {
                    try {
                        string.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    string.close();
                }
            }
        }
        if (object2 instanceof RollbackImpossibleException) {
            logger.severe("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)exception);
            throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)exception);
        }
        logger.severe("\nError executing rollback for the targeted changeset '" + (String)object + "'.");
        throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + exception.getMessage(), (Throwable)exception);
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID_ARG = commandBuilder.argument("changesetId", String.class).description("The id of the changeset to rollback").required().build();
        CHANGESET_AUTHOR_ARG = commandBuilder.argument("changesetAuthor", String.class).description("The author of the changeset to rollback").required().build();
        CHANGESET_PATH_ARG = commandBuilder.argument("changesetPath", String.class).description("The target database password").required().build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
        SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK = commandBuilder.argument("shouldLogMdcChangesetsRolledBack", Boolean.class).hidden().defaultValue((Object)Boolean.TRUE).build();
    }
}

