/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.ChangelogRewriter$MOD_TYPE;
import com.datical.liquibase.ext.changelog.ChangelogRewriterFactory;
import com.datical.liquibase.ext.command.AbstractSetCommandStep;
import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.visitor.ModifyChangeSetLabelsVisitor;
import java.util.Arrays;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.listener.LiquibaseListener;

public class SetLabelsCommandStep
extends AbstractSetCommandStep {
    public static final String STATUS_CODE = "statusCode";
    public static String[] COMMAND_NAME = new String[]{"setLabels"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> SET_AS_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static final CommandArgumentDefinition<String> LABEL_FILTER_ARG;
    public static final CommandArgumentDefinition<String> CONTEXTS_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_REPLACE_ARG;
    public static final CommandArgumentDefinition<String> DBMS_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Bulk set labels in the changelog file"));
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Object object = (String)commandScope.getArgumentValue(DBMS_ARG);
        Database database = this.obtainDatabase((String)object, commandScope);
        Contexts contexts = new Contexts(this.getContextsArg(commandScope));
        LabelExpression labelExpression = new LabelExpression(this.getLabelFilterArg(commandScope));
        try {
            SetLabelsCommandStep setLabelsCommandStep = this;
            DatabaseChangeLog databaseChangeLog = setLabelsCommandStep.parseDatabaseChangelog(setLabelsCommandStep.getChangelogFileArg(commandScope), (String)object, database);
            object = this.determineChangeLogIterator(commandScope, (String)object, database, contexts, labelExpression, databaseChangeLog);
            Scope.child((LiquibaseListener)null, () -> SetLabelsCommandStep.lambda$run$3((ChangeLogIterator)object, commandScope, database, contexts, labelExpression));
            object = ChangelogRewriterFactory.getInstance().createChangelogRewriter(this.getChangelogFileArg(commandScope), databaseChangeLog, null, ChangelogRewriter$MOD_TYPE.LABELS);
            if (object == null) {
                throw new LiquibaseException(String.format("Unsupported changelog type '%s'", this.getChangelogFileArg(commandScope)));
            }
            object.modifyChangelog();
            return;
        }
        catch (Exception exception) {
            commandResultsBuilder.addResult(STATUS_CODE, (Object)1);
            throw exception;
        }
        finally {
            this.cleanUp(commandResultsBuilder);
        }
    }

    private static /* synthetic */ void lambda$run$3(ChangeLogIterator changeLogIterator, CommandScope commandScope, Database database, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run((ChangeSetVisitor)new ModifyChangeSetLabelsVisitor((String)commandScope.getArgumentValue(SET_AS_ARG), (Boolean)commandScope.getArgumentValue(FORCE_REPLACE_ARG)), new RuntimeEnvironment(database, contexts, labelExpression));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().description("The root changelog file").build();
        SET_AS_ARG = commandBuilder.argument("setAs", String.class).required().description("New label values").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return ((String)object).replace("\\\\", "");
            }
            return null;
        }).build();
        CHANGESET_ID_ARG = commandBuilder.argument("changesetId", String.class).description("The id of the changeset to modify").build();
        CHANGESET_AUTHOR_ARG = commandBuilder.argument("changesetAuthor", String.class).description("The author of the changeset to modify").build();
        CHANGESET_PATH_ARG = commandBuilder.argument("changesetPath", String.class).description("The changeset path").build();
        LABEL_FILTER_ARG = commandBuilder.argument("labelFilter", String.class).addAlias("labels").description("Changeset labels to match").build();
        CONTEXTS_ARG = commandBuilder.argument("contextFilter", String.class).description("Changeset contexts to match").build();
        FORCE_REPLACE_ARG = commandBuilder.argument("forceReplace", Boolean.class).defaultValue((Object)Boolean.FALSE).description("Replace the labels if true").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof String && !object.equals("")) {
                if (!Arrays.asList("TRUE", "FALSE").contains(((String)object).toUpperCase())) {
                    throw new IllegalArgumentException("Illegal value for 'forceReplace'.  Valid values are 'TRUE' or 'FALSE'");
                }
                return Boolean.parseBoolean((String)object);
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return null;
        }).build();
        DBMS_ARG = commandBuilder.argument("dbms", String.class).description("The database to filter by").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                object = (String)object;
                SetLabelsCommandStep.validateDbmsString((String)object);
                return object;
            }
            return null;
        }).build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").build();
        DEFAULT_SCHEMA_NAME_ARG = commandBuilder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = commandBuilder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = commandBuilder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = commandBuilder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

