/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import com.datical.liquibase.ext.reports.DriftReportFormat;
import com.datical.liquibase.ext.reports.DriftReportMode;
import com.datical.liquibase.ext.util.ValueHandlerUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class DriftConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<Boolean> ENABLED;
    public static final ConfigurationDefinition<Integer> MISSING_SEVERITY;
    public static final ConfigurationDefinition<Integer> UNEXPECTED_SEVERITY;
    public static final ConfigurationDefinition<Integer> CHANGED_SEVERITY;
    public static final ConfigurationDefinition<DriftReportFormat> REPORT_FORMAT;
    public static final ConfigurationDefinition<String> REPORT_NAME;
    public static final ConfigurationDefinition<String> REPORT_PATH;
    public static final ConfigurationDefinition<DriftReportMode> REPORT_MODE;
    public static final ConfigurationDefinition<Boolean> REPORT_ENABLED;
    public static final String DRIFT_REPORT_NAME_EXAMPLE;

    private static Integer determineSeverity(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = (String)object;
            try {
                int n2 = Integer.parseInt((String)object);
                if (n2 < 0 || n2 > 4) {
                    throw new IllegalArgumentException(String.format("WARNING: The drift report format value '%s' is not valid. Valid values are 0-4", object));
                }
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(String.format("WARNING: The drift report format value '%s' is not valid. Valid values are 0-4", object));
            }
        }
        if (object instanceof Integer) {
            int n3 = (Integer)object;
            if (n3 < 0 || n3 > 4) {
                throw new IllegalArgumentException(String.format("WARNING: The drift report format value '%d' is not valid. Valid values are 0-4", n3));
            }
            return n3;
        }
        return null;
    }

    static {
        DRIFT_REPORT_NAME_EXAMPLE = String.format("report-%s", "dd-MMM-yyyy-HHmmss");
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.drift");
        ENABLED = builder.define("enabled", Boolean.class).setDescription("Enable or disable drift detection").setDefaultValue((Object)Boolean.FALSE).setHidden(true).build();
        MISSING_SEVERITY = builder.define("missing.severity", Integer.class).setDescription("Missing object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
        UNEXPECTED_SEVERITY = builder.define("unexpected.severity", Integer.class).setDescription("Unexpected object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
        CHANGED_SEVERITY = builder.define("changed.severity", Integer.class).setDescription("Changed object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
        REPORT_ENABLED = builder.define("report.enabled", Boolean.class).setDescription("Enable or disable drift reporting.").setDefaultValue((Object)Boolean.FALSE).setValueHandler(ValueHandlerUtil::booleanValueHandler).setHidden(true).build();
        REPORT_FORMAT = builder.define("report.format", DriftReportFormat.class).setDescription("The format of the Drift Report. Currently, can only be set to \"html\".").setValueHandler(object -> ValueHandlerUtil.getEnum(DriftReportFormat.class, object, "Drift Report Format")).setDefaultValue((Object)DriftReportFormat.HTML).setHidden(true).build();
        REPORT_NAME = builder.define("report.name", String.class).setDescription("The name of the Drift Report.").setDefaultValue((Object)DRIFT_REPORT_NAME_EXAMPLE).setHidden(true).build();
        REPORT_PATH = builder.define("report.path", String.class).setDescription("The path to the directory to generate Drift Reports.").setDefaultValue((Object)".").setHidden(true).build();
        REPORT_MODE = builder.define("report.mode", DriftReportMode.class).setDescription(String.format("The report mode of the Drift Report. The report mode defines the differences to include in the Drift Report. Valid modes include: %s", Stream.of(DriftReportMode.values()).map(Enum::name).collect(Collectors.joining(", ")))).setValueHandler(object -> ValueHandlerUtil.getEnum(DriftReportMode.class, object, "Drift Report Mode")).setDefaultValue((Object)DriftReportMode.ALL).setHidden(true).build();
    }
}

