/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.config.LiquibaseFlowConfiguration;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.FlowShellCommandChange;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtil;
import liquibase.util.SystemUtil;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FlowShellCommandAction
extends Action {
    private String command;
    private String expandedCommand;
    private List<String> argsList;
    private FlowShellCommandChange commandChange;
    private String interpreter = SystemUtil.isWindows() ? "cmd" : "bash";
    private static final String COMMAND_KEY = "command";

    @Override
    public String getType() {
        return "shell";
    }

    public String toString() {
        if (Boolean.TRUE.equals(LiquibaseFlowConfiguration.FLOW_VERBOSE_TO_STRING.getCurrentValue())) {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
        return String.format("'%s' %s", this.getType(), this.command);
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(String string) {
        this.interpreter = string;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getExpandedCommand() {
        return this.expandedCommand;
    }

    public void setExpandedCommand(String string) {
        this.expandedCommand = string;
    }

    public List<String> getArgsList() {
        return this.argsList;
    }

    public void setArgsList(List<String> list) {
        this.argsList = list;
    }

    public void setCommandChange(FlowShellCommandChange flowShellCommandChange) {
        this.commandChange = flowShellCommandChange;
    }

    @Override
    public Action fromAction(Map<String, Object> map, Map<String, Object> map2) {
        FlowShellCommandAction flowShellCommandAction = new FlowShellCommandAction();
        String[] stringArray = (String[])map.get(COMMAND_KEY);
        if (StringUtil.isEmpty((String)stringArray)) {
            throw new IllegalArgumentException("Empty command found");
        }
        Map<String, Object> map3 = FlowVariableExpander.expandVariables(Collections.singletonMap(COMMAND_KEY, stringArray), map2);
        stringArray = FlowVariableExpander.execShellToExpand((String)map3.get(COMMAND_KEY));
        flowShellCommandAction.setExpandedCommand((String)stringArray);
        stringArray = FlowShellCommandAction.parseToArray((String)map3.get(COMMAND_KEY));
        if (!stringArray[0].equals(this.interpreter)) {
            FlowShellCommandAction flowShellCommandAction2 = flowShellCommandAction;
            flowShellCommandAction2.setCommand(flowShellCommandAction2.getExpandedCommand());
        } else {
            flowShellCommandAction.setCommand(this.interpreter);
        }
        if (stringArray.length > 1) {
            stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            flowShellCommandAction.setArgsList(Arrays.asList(stringArray));
        }
        map = FlowVariableExpander.expandVariables((Map)map.get("userMetadata"), map2);
        this.addUserMetadata(map, flowShellCommandAction);
        flowShellCommandAction.commandChange = new FlowShellCommandChange();
        return flowShellCommandAction;
    }

    @Override
    public void validate(String string) {
    }

    @Override
    public void execute(CommandResultsBuilder commandResultsBuilder) {
        String string = (String)(commandResultsBuilder = commandResultsBuilder.getCommandScope()).getArgumentValue(FlowCommandStep.FLOW_SHELL_INTERPRETER);
        if (string != null) {
            this.setInterpreter(string);
        }
        Scope.getCurrentScope().getLog(FlowCommandStep.class).info("Using interpreter '" + this.interpreter + "'");
        boolean bl2 = (Boolean)commandResultsBuilder.getArgumentValue(FlowCommandStep.FLOW_SHELL_KEEP_TEMP_FILES);
        this.run(bl2);
    }

    public void run(boolean bl2) {
        if (!this.command.equals(this.interpreter)) {
            Object object = FlowShellCommandAction.createTempFile(bl2, this.interpreter);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.interpreter.equals("cmd")) {
                arrayList.add("@ECHO OFF");
            }
            String[] stringArray = this.getExpandedCommand().split("\n");
            arrayList.addAll(Arrays.asList(stringArray));
            FlowShellCommandAction.addCommandsToTempFile(arrayList.toArray(new String[0]), (Path)object);
            this.setArgsList(new ArrayList<String>());
            if (this.interpreter.equals("cmd")) {
                this.argsList.add("/c");
            } else {
                this.argsList.add("-c");
            }
            object = object.toFile().getAbsolutePath();
            if (SystemUtil.isWindows() && this.interpreter.equals("bash")) {
                object = ((String)object).replace("\\", "\\\\");
            }
            this.argsList.add((String)object);
        }
        FlowShellCommandAction flowShellCommandAction = this;
        flowShellCommandAction.setCommand(flowShellCommandAction.interpreter);
        this.commandChange.setExecutable(this.command);
        if (this.argsList != null) {
            this.argsList.forEach(arg_0 -> ((FlowShellCommandChange)this.commandChange).addArg(arg_0));
        }
        this.commandChange.createShellCommandArray();
        try {
            this.commandChange.executeShellCommand();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Path createTempFile(boolean bl2, String object) {
        Path path;
        try {
            if (SystemUtil.isWindows()) {
                if (((String)object).equals("bash")) {
                    object = Files.createTempFile("flow-", ".sh", new FileAttribute[0]).toFile();
                    if (!((File)object).setExecutable(true)) {
                        throw new UnexpectedLiquibaseException("Unable to set file '" + ((File)object).getAbsolutePath() + "' as executable");
                    }
                } else {
                    object = Files.createTempFile("flow-", ".bat", new FileAttribute[0]).toFile();
                }
            } else {
                object = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
                object = Files.createTempFile("flow-", ".sh", new FileAttribute[]{object}).toFile();
            }
            if (!bl2) {
                ((File)object).deleteOnExit();
            }
            path = ((File)object).toPath();
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
        return path;
    }

    private static String[] parseToArray(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return new String[0];
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        block4: while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if ("'".equals(stringArray)) {
                        bl2 = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(stringArray)) {
                        bl2 = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
            }
            if ("'".equals(stringArray)) {
                n2 = 1;
            } else if ("\"".equals(stringArray)) {
                n2 = 2;
            } else if (" ".equals(stringArray)) {
                if (bl2 || stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
            } else {
                stringBuilder.append((String)stringArray);
            }
            bl2 = false;
        }
        if (bl2 || stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n2 == 1 || n2 == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in ".concat(String.valueOf(string)));
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addCommandsToTempFile(String[] object, Path object2) {
        try {
            block12: {
                object2 = Files.newBufferedWriter((Path)object2, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    int n2 = ((Object)object).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = ((String)object[i2]).trim().replace("\r", "");
                        ((Writer)object2).write(string + "\n");
                    }
                    if (object2 == null) return;
                    if (throwable == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable4) {
                        if (object2 == null) throw throwable4;
                        if (throwable == null) {
                            ((BufferedWriter)object2).close();
                            throw throwable4;
                        }
                        try {
                            ((BufferedWriter)object2).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                try {
                    ((BufferedWriter)object2).close();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return;
                }
            }
            ((BufferedWriter)object2).close();
            return;
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
    }
}

