/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Database;
import liquibase.repackaged.net.sf.jsqlparser.schema.MultiPartName;
import liquibase.repackaged.net.sf.jsqlparser.schema.Sequence$Parameter;

public class Sequence
extends ASTNodeAccessImpl
implements MultiPartName {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();
    private List<Sequence$Parameter> parameters;

    public Sequence() {
    }

    public Sequence(List<String> list) {
        this.partItems = new ArrayList<String>(list);
        Collections.reverse(this.partItems);
    }

    public void setParameters(List<Sequence$Parameter> list) {
        this.parameters = list;
    }

    public List<Sequence$Parameter> getParameters() {
        return this.parameters;
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
        if (database.getServer() != null) {
            this.setIndex(3, database.getServer().getFullyQualifiedName());
        }
    }

    public Sequence withDatabase(Database database) {
        this.setDatabase(database);
        return this;
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public void setSchemaName(String string) {
        this.setIndex(1, string);
    }

    public Sequence withSchemaName(String string) {
        this.setSchemaName(string);
        return this;
    }

    public String getName() {
        return this.getIndex(0);
    }

    public void setName(String string) {
        this.setIndex(0, string);
    }

    public Sequence withName(String string) {
        this.setName(string);
        return this;
    }

    private void setIndex(int n2, String string) {
        int n3 = this.partItems.size();
        for (int i2 = 0; i2 < n2 - n3 + 1; ++i2) {
            this.partItems.add(null);
        }
        this.partItems.set(n2, string);
    }

    private String getIndex(int n2) {
        if (n2 < this.partItems.size()) {
            return this.partItems.get(n2);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = this.partItems.size() - 1; i2 >= 0; --i2) {
            String string = this.partItems.get(i2);
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
            if (i2 == 0) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getFullyQualifiedName());
        if (this.parameters != null) {
            for (Sequence$Parameter sequence$Parameter : this.parameters) {
                stringBuilder.append(" ").append(sequence$Parameter.formatParameter());
            }
        }
        return stringBuilder.toString();
    }

    public Sequence withParameters(List<Sequence$Parameter> list) {
        this.setParameters(list);
        return this;
    }

    public Sequence addParameters(Sequence$Parameter ... sequence$ParameterArray) {
        List list = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        Collections.addAll(list, sequence$ParameterArray);
        return this.withParameters(list);
    }

    public Sequence addParameters(Collection<? extends Sequence$Parameter> collection) {
        List list = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withParameters(list);
    }
}

