/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter$KeyValuePair;
import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter$MOD_TYPE;
import com.datical.liquibase.ext.changelog.ChangelogRewriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.IncludeAllFilter;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public abstract class AbstractChangelogRewriter {
    public static final String IGNORE = "ignore";
    protected final String includedPath;
    protected String changelogFile;
    protected DatabaseChangeLog databaseChangelog;
    protected ChangelogRewriter$MOD_TYPE modType;

    protected AbstractChangelogRewriter(String string, DatabaseChangeLog databaseChangeLog, ChangelogRewriter$MOD_TYPE changelogRewriter$MOD_TYPE, String string2) {
        this.changelogFile = string;
        this.databaseChangelog = databaseChangeLog;
        this.modType = changelogRewriter$MOD_TYPE;
        this.includedPath = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyChangelog() {
        InputStream inputStream = null;
        try {
            Object object = Scope.getCurrentScope().getResourceAccessor().getExisting(this.changelogFile);
            inputStream = object.openInputStream();
            String string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String string2 = StreamUtil.readStreamAsString((InputStream)inputStream, (String)string);
            String string3 = this.handle(string2);
            object = object.getUri();
            string = this.writeChangelog((URI)object, string, string2, string3) ? "* Changelog file '" + this.changelogFile + "' modified successfully." : "* Changelog file '" + this.changelogFile + "' was not modified.";
            Scope.getCurrentScope().getUI().sendMessage(string);
        }
        catch (IOException | LiquibaseException throwable) {
            try {
                String string4 = "* Changelog file '" + this.changelogFile + "' error: " + throwable.getMessage();
                Scope.getCurrentScope().getLog(AbstractChangelogRewriter.class).severe(string4);
                throw new LiquibaseException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    if (inputStream == null) throw throwable2;
                    inputStream.close();
                    throw throwable2;
                }
                catch (IOException iOException) {}
                throw throwable2;
            }
        }
        try {
            if (inputStream == null) return;
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public abstract String handle(String var1);

    protected boolean writeChangelog(URI object, String object2, String string, String object3) {
        if (((String)object3).equals(string)) {
            return false;
        }
        string = object3;
        object = new File(((URI)object).getPath());
        object = new RandomAccessFile((File)object, "rw");
        object3 = null;
        try {
            ((RandomAccessFile)object).setLength(0L);
            ((RandomAccessFile)object).write(string.getBytes((String)object2));
        }
        catch (Throwable throwable) {
            object2 = throwable;
            object3 = throwable;
            throw object2;
        }
        finally {
            if (object3 != null) {
                try {
                    ((RandomAccessFile)object).close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object3).addSuppressed(throwable);
                }
            } else {
                ((RandomAccessFile)object).close();
            }
        }
        return true;
    }

    protected String determinePath(String string) {
        if (this.includedPath != null) {
            return this.includedPath;
        }
        return this.changelogFile;
    }

    protected String getPath(DatabaseChangeLog databaseChangeLog) {
        String string = this.changelogFile;
        if (databaseChangeLog.getLogicalFilePath() != null) {
            string = databaseChangeLog.getLogicalFilePath();
        }
        return string;
    }

    protected ChangeSet getChangeSet(String string, String string2) {
        ChangeSet changeSet = this.databaseChangelog.getChangeSet(this.changelogFile, string, string2);
        if (changeSet == null) {
            for (ChangeSet changeSet2 : this.databaseChangelog.getSkippedChangeSets()) {
                if (!changeSet2.getId().equalsIgnoreCase(string2) || !changeSet2.getAuthor().equalsIgnoreCase(string) || !this.changelogFile.equals(changeSet2.getFilePath()) || this.databaseChangelog.isDbmsMatch(changeSet2.getDbmsSet())) continue;
                Scope.getCurrentScope().getLog(AbstractChangelogRewriter.class).info("Mismatched DBMS value for changeset '" + changeSet2 + "'");
            }
        }
        return changeSet;
    }

    protected String createContextStringForFile(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.getContextFilter().getContexts().toString().replace("[", "").replace("]", "").replace(", ", ",");
    }

    protected void handleIncludedFile(String string) {
        ChangelogRewriter changelogRewriter = ChangelogRewriterFactory.getInstance().createChangelogRewriter(string, this.databaseChangelog, string, this.modType);
        if (changelogRewriter == null) {
            string = String.format("Unsupported changelog type '%s'", string);
            Scope.getCurrentScope().getUI().sendMessage(string);
            return;
        }
        changelogRewriter.modifyChangelog();
    }

    protected String getFirstGroupValue(String object, Pattern pattern) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            return ((Matcher)object).group(1);
        }
        return null;
    }

    protected AbstractChangelogRewriter$KeyValuePair parseKeyValuePair(String[] object) {
        String string = object[0].replace("\"", "").trim();
        String string2 = null;
        if (((String[])object).length > 1) {
            string2 = object[1].replace("\",", "").replace("\"", "").trim();
        }
        object = new AbstractChangelogRewriter$KeyValuePair();
        new AbstractChangelogRewriter$KeyValuePair().key = string;
        object.value = string2;
        return object;
    }

    protected Comparator<String> getStandardChangeLogComparator() {
        return Comparator.comparing(string -> string.replace("WEB-INF/classes/", ""));
    }

    protected Comparator<String> getResourceComparator(String comparator) {
        if (comparator == null) {
            return this.getStandardChangeLogComparator();
        }
        try {
            comparator = (Comparator)Class.forName((String)((Object)comparator)).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Scope.getCurrentScope().getLog(this.getClass()).info("no resourceComparator defined - taking default implementation");
            comparator = this.getStandardChangeLogComparator();
        }
        return comparator;
    }

    protected IncludeAllFilter getIncludeAllFilter(String string) {
        IncludeAllFilter includeAllFilter = null;
        if (string != null) {
            try {
                includeAllFilter = (IncludeAllFilter)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new SetupException((Throwable)reflectiveOperationException);
            }
        }
        return includeAllFilter;
    }

    protected void handleFoundResources(String object, boolean bl2, SortedSet<Resource> sortedSet) {
        if (sortedSet.isEmpty() && bl2) {
            throw new SetupException("Could not find directory or directory was empty for includeAll '" + (String)object + "'");
        }
        try {
            for (Resource resource : sortedSet) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Handling resource: ".concat(String.valueOf(resource)));
                this.handleIncludedFile(resource.getPath());
            }
            return;
        }
        catch (Exception exception) {
            throw new SetupException((Throwable)exception);
        }
    }

    protected List<Map<String, Object>> parseRootList(String string) {
        Object object = new Yaml((BaseConstructor)new SafeConstructor(YamlParser.createLoaderOptions()));
        Object object2 = Scope.getCurrentScope().getResourceAccessor().get(string);
        if (!object2.exists()) {
            throw new ChangeLogParseException(string + " does not exist");
        }
        string = object2.getUri().toString();
        object2 = object2.openInputStream();
        Throwable throwable = null;
        try {
            object = this.parseYamlStream(string, (Yaml)object, (InputStream)object2);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            if (object2 != null) {
                if (throwable != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    ((InputStream)object2).close();
                }
            }
        }
        if (object == null || object.isEmpty()) {
            throw new ChangeLogParseException("Empty file ".concat(String.valueOf(string)));
        }
        return (List)object.get("databaseChangeLog");
    }

    protected void handleIncludes(String iterator) {
        try {
            AbstractChangelogRewriter abstractChangelogRewriter = this;
            iterator = abstractChangelogRewriter.parseRootList(abstractChangelogRewriter.changelogFile);
            if (iterator == null) {
                return;
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (!(map instanceof Map)) continue;
                String string = (String)map.keySet().iterator().next();
                map = (Map)map.get(string);
                if (string.equals("includeAll")) {
                    this.handleResources(map);
                    continue;
                }
                if (!string.equals("include")) continue;
                string = (String)map.get("file");
                boolean bl2 = map.get(IGNORE) instanceof String ? Boolean.parseBoolean((String)map.get(IGNORE)) : (Boolean)map.get(IGNORE);
                if (bl2) {
                    String string2 = "Ignoring include '" + string + "'";
                    Scope.getCurrentScope().getUI().sendMessage(string2);
                    continue;
                }
                this.handleIncludedFile(string);
            }
            return;
        }
        catch (IOException | ChangeLogParseException throwable) {
            throw new LiquibaseException(throwable);
        }
    }

    private Map parseYamlStream(String string, Yaml object, InputStream inputStream) {
        try {
            object = (Map)object.load(inputStream);
        }
        catch (Exception exception) {
            throw new ChangeLogParseException("Syntax error in file " + string + ": " + exception.getMessage(), (Throwable)exception);
        }
        return object;
    }

    private void handleResources(Map<String, Object> map) {
        String string = (String)map.get("path");
        if (Boolean.parseBoolean((String)map.get(IGNORE))) {
            String string2 = "Ignoring includeAll path '" + string + "'";
            Scope.getCurrentScope().getUI().sendMessage(string2);
            return;
        }
        String string3 = (String)map.get("filter");
        if (string3 == null) {
            string3 = (String)map.get("resourceFilter");
        }
        boolean bl2 = map.containsKey("relativeToChangelogFile") && (Boolean)map.get("relativeToChangelogFile") != false;
        boolean bl3 = !map.containsKey("errorIfMissingOrEmpty") || (Boolean)map.get("errorIfMissingOrEmpty") != false;
        Comparator<String> comparator = this.getStandardChangeLogComparator();
        string3 = this.getIncludeAllFilter(string3);
        int n2 = map.containsKey("minDepth") ? (Integer)map.get("minDepth") : 0;
        int n3 = map.containsKey("maxDepth") ? (Integer)map.get("maxDepth") : Integer.MAX_VALUE;
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        SortedSet sortedSet = this.databaseChangelog.findResources(string, bl2, (IncludeAllFilter)string3, bl3, comparator, resourceAccessor, n2, n3);
        this.handleFoundResources(string, bl3, sortedSet);
    }
}

