/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.resource.Resource;

public class FlowValidateCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow", "validate"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<String> FLOW_SHELL_INTERPRETER;
    public static final CommandArgumentDefinition<Boolean> FLOW_SHELL_KEEP_TEMP_FILES;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final CommandArgumentDefinition<FlowFile> FLOW_FILE_DTO;
    public static final String VALIDATED_KEY = "validated";
    public static final String FLOW_FILE_KEY = "flowFile";
    public static final String FLOW_FILE_LOAD_KEY = "flowFilePath";
    public static final String END_STAGE = "endStage";

    private void validateActions(List<Action> object, Map<String, List<Exception>> map, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            Action action = (Action)object.next();
            try {
                action.validate(string);
            }
            catch (CommandExecutionException commandExecutionException) {
                if (map.containsKey(action.toString())) {
                    map.get(action.toString()).add((Exception)((Object)commandExecutionException));
                    continue;
                }
                ArrayList<CommandExecutionException> arrayList = new ArrayList<CommandExecutionException>();
                arrayList.add(commandExecutionException);
                map.put(action.toString(), arrayList);
            }
        }
    }

    private void validateStage(Stage stage, String string, LinkedHashMap<String, Map<String, List<Exception>>> linkedHashMap, FlowFileLoad flowFileLoad, String string2, boolean bl2) {
        if (stage == null) {
            return;
        }
        LinkedHashMap<String, List<Exception>> linkedHashMap2 = new LinkedHashMap<String, List<Exception>>();
        if (this.isEndStage(string, bl2)) {
            Scope.getCurrentScope().getUI().sendMessage("WARNING: The stage named '" + string + "' will not be guaranteed to execute by Liquibase Flow because it falls under the 'stages:' object in the flow file. To guarantee execution of this stage, it should be not be indented.");
        }
        this.validateActions(stage.getActions(), linkedHashMap2, string2);
        if (!linkedHashMap2.isEmpty()) {
            linkedHashMap.put(string, linkedHashMap2);
        }
        stage.getActions().forEach(action -> this.addNestedFilesToMap(string, flowFileLoad, string2, (Action)action));
    }

    private void addNestedFilesToMap(String string, FlowFileLoad flowFileLoad, String string2, Action object) {
        if (!this.isFlowCommand((Action)object)) {
            return;
        }
        object = ((LiquibaseCommandAction)object).getCmdArgs();
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry resource : object.entrySet()) {
            treeMap.put(((String)resource.getKey()).replace("-", ""), resource.getValue());
        }
        object = (String)treeMap.get(FLOW_FILE_KEY);
        try {
            Resource resource = FlowFileHelper.determineResource((String)object);
            string2 = FlowFileHelper.determineResource(string2);
            if (this.isNotParent(resource, (Resource)string2)) {
                if (flowFileLoad.nestedFlowFiles == null) {
                    flowFileLoad.nestedFlowFiles = new LinkedHashMap<String, String>();
                }
                flowFileLoad.nestedFlowFiles.put((String)object, string);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private boolean isNotParent(Resource resource, Resource resource2) {
        return resource2 != null && !resource2.getUri().toString().equalsIgnoreCase(resource.getUri().toString());
    }

    private boolean isFlowCommand(Action object) {
        return (object = ((Action)object).getCommand()) != null && ((String)object).equalsIgnoreCase("flow");
    }

    private boolean isEndStage(String string, boolean bl2) {
        return bl2 && string.equalsIgnoreCase("endstage");
    }

    private void outputValidationErrors(LinkedHashMap<String, Map<String, List<Exception>>> object, StringBuilder stringBuilder) {
        if (!((HashMap)((Object)object)).isEmpty()) {
            StringBuilder stringBuilder2 = stringBuilder;
            for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
                Map map = (Map)entry.getValue();
                String object2 = (String)entry.getKey();
                for (Map.Entry entry2 : map.entrySet()) {
                    for (Exception exception : (List)entry2.getValue()) {
                        String string = (String)entry2.getKey();
                        stringBuilder.append("Invalid command in stage: ");
                        stringBuilder.append(object2);
                        stringBuilder.append(": ");
                        stringBuilder.append(string);
                        stringBuilder.append(": ");
                        stringBuilder.append(exception);
                        stringBuilder.append(System.lineSeparator());
                    }
                }
            }
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Please review for errors. Learn more at https://docs.liquibase.com/commands/flow/flow.html");
            Scope.getCurrentScope().getUI().sendMessage(stringBuilder.toString());
            stringBuilder2.append("Please review for errors. Learn more at https://docs.liquibase.com/commands/flow/flow.html");
            throw new CommandValidationException(stringBuilder2.toString());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        FlowFileLoad flowFileLoad;
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Object object = commandScope.getConfiguredValue(FLOW_FILE);
        ConfiguredValue configuredValue = commandScope.getConfiguredValue(FLOW_FILE_DTO);
        if (configuredValue.getValue() != null && object.getValue() != null && !object.wasDefaultValueUsed()) {
            throw new IllegalArgumentException("You can only pass in 1 of 'flowFile' and 'flowFileDTO'");
        }
        String string = null;
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(object.getValue());
        try {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            if (configuredValue.getValue() != null) {
                object = (FlowFile)configuredValue.getValue();
                flowFileLoad = new FlowFileLoad();
                new FlowFileLoad().flowFile = object;
            } else {
                string = (String)atomicReference.get();
                serializable3 = new AtomicReference();
                serializable2 = new AtomicReference();
                serializable = new HashMap<String, Object>();
                serializable.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
                serializable.put(FLOW_SHELL_KEEP_TEMP_FILES.getName(), commandScope.getArgumentValue(FLOW_SHELL_KEEP_TEMP_FILES));
                Scope.child(serializable, () -> this.lambda$run$1(serializable3, atomicReference, (ConfiguredValue)object, commandScope, (AtomicReference)serializable2));
                object = (FlowFile)((AtomicReference)serializable2).get();
                flowFileLoad = (FlowFileLoad)((AtomicReference)serializable3).get();
            }
            if (object == null) {
                commandResultsBuilder.addResult(VALIDATED_KEY, (Object)Boolean.FALSE);
                return;
            }
            serializable3 = new LinkedHashMap();
            serializable2 = new HashMap<String, Object>();
            serializable2.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
            serializable2.put(FLOW_SHELL_KEEP_TEMP_FILES.getName(), commandScope.getArgumentValue(FLOW_SHELL_KEEP_TEMP_FILES));
            Scope.child((Map)((Object)serializable2), () -> this.lambda$run$2((FlowFile)object, serializable3, flowFileLoad, atomicReference));
            serializable = configuredValue.getValue() == null ? new StringBuilder(String.format("ERROR: Flow file failed validation checks.%n", new Object[0])) : new StringBuilder(String.format("ERROR: Flow file object failed validation checks.%n", new Object[0]));
            this.outputValidationErrors((LinkedHashMap<String, Map<String, List<Exception>>>)serializable3, (StringBuilder)serializable);
        }
        catch (IOException iOException) {
            throw new CommandValidationException(String.format("Error opening file '%s': %s", string, iOException.getMessage()));
        }
        if (string != null) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("Flow file %s is valid.", string));
        } else {
            Scope.getCurrentScope().getUI().sendMessage("Flow file object is valid.");
        }
        Scope.getCurrentScope().getUI().sendMessage("Flow file " + string + " is valid.");
        commandResultsBuilder.addResult(VALIDATED_KEY, (Object)Boolean.TRUE);
        commandResultsBuilder.addResult(FLOW_FILE_LOAD_KEY, (Object)flowFileLoad);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Validate a series of commands contained in one or more stages, as configured in a liquibase flow-file."));
    }

    private /* synthetic */ void lambda$run$2(FlowFile flowFile, LinkedHashMap linkedHashMap, FlowFileLoad flowFileLoad, AtomicReference atomicReference) {
        for (Map.Entry<String, Stage> entry : flowFile.getStages().entrySet()) {
            Stage stage = entry.getValue();
            String object = entry.getKey();
            this.validateStage(stage, object, linkedHashMap, flowFileLoad, (String)atomicReference.get(), true);
        }
        this.validateStage(flowFile.getEndStage(), END_STAGE, linkedHashMap, flowFileLoad, (String)atomicReference.get(), false);
    }

    private /* synthetic */ void lambda$run$1(AtomicReference atomicReference, AtomicReference atomicReference2, ConfiguredValue configuredValue, CommandScope commandScope, AtomicReference atomicReference3) {
        atomicReference.set(this.loadFlowFileContents((String)atomicReference2.get(), configuredValue.wasDefaultValueUsed(), (Boolean)commandScope.getArgumentValue(FLOW_FILE_STRICT_PARSING) == false));
        atomicReference3.set(atomicReference.get() != null ? ((FlowFileLoad)atomicReference.get()).flowFile : null);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument(FLOW_FILE_KEY, String.class).defaultValue((Object)"liquibase.flowfile.yaml").description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)Boolean.TRUE).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
        FLOW_SHELL_INTERPRETER = commandBuilder.argument("flowShellInterpreter", String.class).description("The default interpreter used to execute shell commands.").build();
        FLOW_SHELL_KEEP_TEMP_FILES = commandBuilder.argument("flowShellKeepTempFiles", Boolean.class).defaultValue((Object)Boolean.FALSE).description("Do not delete temporary files created by the shell command execution").build();
        FLOW_FILE_DTO = commandBuilder.argument("flowFileDTO", FlowFile.class).description("An already loaded FlowFile object").hidden().build();
    }
}

