/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputModel;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputSerializer;
import com.datical.liquibase.ext.checks.output.FormattedChecksReportResultModel;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksResultModel;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksOutput;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep$1;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper;
import com.datical.liquibase.ext.command.checks.ChecksRunJsonOutputHelper;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.ChangesetQualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.DatabaseQualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.util.ValueHandlerUtil;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.database.core.H2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.CommandValidationException;
import liquibase.exception.MissingRequiredArgumentException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChecksRunCommandStep
extends AbstractChecksCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String[] COMMAND_NAME = new String[]{"checks", "run"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SCOPE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_OUTPUT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> SCHEMAS_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;
    public static final CommandArgumentDefinition<Boolean> VERBOSE_ARG;
    public static final CommandArgumentDefinition<Boolean> CACHE_CHANGELOG_FILE_CONTENTS;
    public static final CommandArgumentDefinition<String> LABELS_ARG;
    public static final CommandArgumentDefinition<String> CONTEXTS_ARG;
    public static final CommandArgumentDefinition<Boolean> CHECK_ROLLBACKS_ARG;
    public static final CommandArgumentDefinition<CheckSettingsConfig> CHECKS_SETTINGS_FILE_DTO;
    public static final CommandArgumentDefinition<String> CHECKS_OUTPUT_ARG;
    public static final CommandArgumentDefinition<Level> SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG;
    public static final CommandArgumentDefinition<Integer> SQL_PARSER_FAIL_SEVERITY;

    @Override
    public void validate(CommandScope object) {
        String string = (String)object.getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        String string2 = (String)object.getConfiguredValue(URL_ARG).getValue();
        if (string == null && string2 == null) {
            throw new CommandValidationException("changelogFile, url", "one is required for 'checks run'", (Throwable)new MissingRequiredArgumentException("--changelog-file, --url"));
        }
        String string3 = (String)object.getConfiguredValue(CHECKS_SCOPE_ARG).getValue();
        if (string3.toUpperCase().contains(ScopeEnum.CHANGELOG.toString()) && string == null) {
            throw new CommandValidationException(CHECKS_SCOPE_ARG.getName(), "you must supply a changelogFile argument for changelog checks", (Throwable)new MissingRequiredArgumentException(CHECKS_SCOPE_ARG.getName()));
        }
        if (string3.toUpperCase().contains(ScopeEnum.DATABASE.toString()) && string2 == null) {
            throw new CommandValidationException(CHECKS_SCOPE_ARG.getName(), "you must supply a URL argument for database checks", (Throwable)new MissingRequiredArgumentException(CHECKS_SCOPE_ARG.getName()));
        }
        string = (String)object.getArgumentValue(CHECKS_OUTPUT_ARG);
        object = (String)object.getArgumentValue(CHECKS_OUTPUT_FORMAT_ARG);
        ChecksOutput.parseAndValidateArgumentsString(string, (String)object);
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        Object object = commandResultsBuilder.getCommandScope();
        hashMap.put(CACHE_CHANGELOG_FILE_CONTENTS.getName(), object.getConfiguredValue(CACHE_CHANGELOG_FILE_CONTENTS).getValue());
        if (this.isMavenIntegration(commandResultsBuilder)) {
            object = new InMemoryChecksFileAccessor();
            hashMap.put("fileAccessor", object);
        }
        Scope.child(hashMap, () -> this.doRun(commandResultsBuilder));
    }

    private void doRun(CommandResultsBuilder commandResultsBuilder) {
        EngineResults<DatabaseObject> engineResults;
        CheckSettingsConfig checkSettingsConfig;
        ChangeLogParser changeLogParser;
        CharSequence charSequence;
        boolean bl2;
        Database database;
        LazyDatabaseSnapshot lazyDatabaseSnapshot;
        LinkedHashSet<ChecksOutput> linkedHashSet;
        String string;
        Integer n2;
        Object object;
        Object object2;
        String string2;
        String string3;
        Object object3;
        Object object4;
        Object object5;
        block60: {
            boolean bl3;
            Level level;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            block59: {
                block58: {
                    block57: {
                        object5 = commandResultsBuilder.getCommandScope();
                        object4 = (String)object5.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
                        ChecksRunCommandStep.checkFileArgExistence((String)object4, "checks settings");
                        object3 = (String)object5.getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
                        object3 = new CheckSettingsConfigHelper((String)object4, (String)object3);
                        string3 = (String)object5.getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
                        ChecksRunCommandStep.checkFileArgExistence(string3, "changelog");
                        string2 = (String)object5.getArgumentValue(URL_ARG);
                        string9 = JdbcConnection.sanitizeUrl((String)string2);
                        object2 = (String)object5.getArgumentValue(USERNAME_ARG);
                        object = (String)object5.getArgumentValue(PASSWORD_ARG);
                        string8 = (String)object5.getArgumentValue(DEFAULT_SCHEMA_NAME_ARG);
                        string7 = (String)object5.getArgumentValue(DEFAULT_CATALOG_NAME_ARG);
                        string6 = (String)object5.getArgumentValue(DRIVER_ARG);
                        string5 = (String)object5.getArgumentValue(DRIVER_PROPERTIES_FILE_ARG);
                        string4 = (String)object5.getArgumentValue(SCHEMAS_ARG);
                        level = (Level)object5.getArgumentValue(SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG);
                        n2 = (Integer)object5.getArgumentValue(SQL_PARSER_FAIL_SEVERITY);
                        string = (String)object5.getArgumentValue(CHECKS_OUTPUT_FORMAT_ARG);
                        linkedHashSet = ChecksOutput.parseAndValidateArgumentsString((String)object5.getArgumentValue(CHECKS_OUTPUT_ARG), string);
                        lazyDatabaseSnapshot = null;
                        database = null;
                        try {
                            String string10 = (String)object5.getConfiguredValue(CHECKS_SCOPE_ARG).getValue();
                            bl2 = string10.toUpperCase().contains(ScopeEnum.DATABASE.toString());
                            bl3 = string10.toUpperCase().contains(ScopeEnum.CHANGELOG.toString());
                            if (bl2) {
                                lazyDatabaseSnapshot = new LazyDatabaseSnapshot(string2, (String)object2, (String)object, string8, string7, string4, string6, string5);
                                this.sendMessageToUi("Executing Quality Checks against database " + string9 + System.lineSeparator());
                                commandResultsBuilder.addResult("statusCode", (Object)0);
                            }
                            string4 = null;
                            if (string3 == null || !bl3) break block57;
                            this.sendMessageToUi("Executing Quality Checks against " + string3 + System.lineSeparator());
                            charSequence = Scope.getCurrentScope().getResourceAccessor();
                            changeLogParser = ChangeLogParserFactory.getInstance().getParser(string3, (ResourceAccessor)charSequence);
                            try {
                                string4 = changeLogParser.parse(string3, new ChangeLogParameters(), (ResourceAccessor)charSequence);
                            }
                            catch (ChangeLogParseException changeLogParseException) {
                                object3 = String.format("%nThe changelog file %s cannot be found or is not a valid changelog: %s%nCorrect this issue and try to run checks again.", string3, changeLogParseException.getMessage());
                                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object3);
                                Scope.getCurrentScope().getUI().sendMessage((String)object3);
                                try {
                                    if (lazyDatabaseSnapshot != null) {
                                        lazyDatabaseSnapshot.close();
                                    }
                                }
                                catch (Exception exception) {}
                                try {
                                    if (database != null) {
                                        database.close();
                                    }
                                    return;
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (lazyDatabaseSnapshot != null) {
                                    lazyDatabaseSnapshot.close();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (database != null) {
                                    database.close();
                                }
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                    charSequence = (String)object5.getConfiguredValue(CHECK_NAME_ARG).getValue();
                    changeLogParser = ChecksRunCommandStep.listAllRules();
                    checkSettingsConfig = (CheckSettingsConfig)object5.getArgumentValue(CHECKS_SETTINGS_FILE_DTO);
                    if (checkSettingsConfig != null) break block58;
                    try {
                        checkSettingsConfig = ((CheckSettingsConfigHelper)object3).read((List<AbstractLiquibaseRule>)changeLogParser);
                    }
                    catch (Exception exception) {
                        object3 = exception;
                        if (exception.getCause() != null && ((Throwable)object3).getCause() instanceof FileAlreadyExistsException) {
                            throw object3;
                        }
                        object4 = String.format("%nUnable to read checks settings file '%s': %s%nCorrect this issue and try to run checks again.", object4, ((Throwable)object3).getMessage());
                        Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object4);
                        Scope.getCurrentScope().getUI().sendMessage((String)object4);
                        try {
                            if (lazyDatabaseSnapshot != null) {
                                lazyDatabaseSnapshot.close();
                            }
                        }
                        catch (Exception exception2) {}
                        try {
                            if (database != null) {
                                database.close();
                            }
                            return;
                        }
                        catch (Exception exception3) {
                            return;
                        }
                    }
                }
                if (checkSettingsConfig != null) break block59;
                commandResultsBuilder.addResult("statusCode", (Object)0);
                try {
                    if (lazyDatabaseSnapshot != null) {
                        lazyDatabaseSnapshot.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (database != null) {
                        database.close();
                    }
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            object3 = ChecksRunCommandStep.determineRulesToRun(checkSettingsConfig, (String)charSequence);
            this.printLicensingMessages((List<AbstractLiquibaseRule>)changeLogParser, (List<AbstractConfigurableRule>)object3, (String)charSequence, bl3, bl2);
            object4 = new EngineResults();
            if (string4 != null) {
                Contexts contexts = new Contexts((String)object5.getArgumentValue(CONTEXTS_ARG));
                object4 = new LabelExpression((String)object5.getArgumentValue(LABELS_ARG));
                string4 = new ChangeLogIterator((DatabaseChangeLog)string4, new ChangeSetFilter[]{new ContextChangeSetFilter(contexts), new LabelChangeSetFilter((LabelExpression)object4)});
                charSequence = new ListVisitor();
                database = this.getDatabaseForChecks(string2, string9, (String)object2, (String)object, string8, string7, string6, string5);
                string4.run((ChangeSetVisitor)charSequence, new RuntimeEnvironment(database, contexts, (LabelExpression)object4));
                boolean bl4 = (Boolean)object5.getArgumentValue(CHECK_ROLLBACKS_ARG);
                object4 = this.runChecks((List<AbstractLiquibaseRule>)changeLogParser, charSequence.getSeenChangeSets(), database, (List<AbstractConfigurableRule>)object3, bl4, level);
            }
            new EngineResults();
            engineResults = this.runDatabaseChecks((List<AbstractLiquibaseRule>)changeLogParser, lazyDatabaseSnapshot, (List<AbstractConfigurableRule>)object3);
            if (lazyDatabaseSnapshot != null && lazyDatabaseSnapshot.isAttempted()) {
                commandResultsBuilder.addResult("snapshot", (Object)lazyDatabaseSnapshot.getSnapshot());
            }
            if (!((EngineResults)object4).getExecutedRules().isEmpty() || !engineResults.getExecutedRules().isEmpty() || !engineResults.getSkippedBecauseOfLicenceRules().isEmpty() || !LicenseServiceUtils.isProLicenseValid()) break block60;
            object4 = "\nWarning:  No checks were executed\nChangesets Validated:  None\nChecks run against each changeset:  None\n\n";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object4);
            this.sendMessageToUi((String)object4);
            commandResultsBuilder.addResult("statusCode", (Object)0);
            try {
                if (lazyDatabaseSnapshot != null) {
                    lazyDatabaseSnapshot.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (database != null) {
                    database.close();
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        boolean bl5 = (Boolean)object5.getConfiguredValue(VERBOSE_ARG).getValue();
        if (ChecksRunCommandStep.isJsonOutput(string)) {
            charSequence = new StringBuilder();
            String string11 = (String)object5.getConfiguredValue(CHECKS_INTEGRATION_ARG).getValue();
            object5 = new FormattedChecksOutputModel();
            new FormattedChecksOutputModel().checksRun = new Date().toString();
            object3 = new FormattedChecksReportResultModel();
            object5.checksReport.add((FormattedChecksReportResultModel)((Object)object3));
            object2 = SeverityEnum.INFO;
            object = SeverityEnum.INFO;
            if (string3 != null) {
                object4 = ChecksRunJsonOutputHelper.createChangelogJsonOutput(((EngineResults)object4).getResults(), ((EngineResults)object4).getExecutedRules(), string3, string11, checkSettingsConfig, ((EngineResults)object4).getSkippedBecauseOfLicenceRules(), (List<AbstractLiquibaseRule>)changeLogParser, n2);
                object2 = ((FormattedChangelogChecksResultModel)((Object)object4)).maxSeverity;
                ((FormattedChecksReportResultModel)((Object)object3)).changelogChecks.add((FormattedChangelogChecksResultModel)((Object)object4));
            }
            if (lazyDatabaseSnapshot != null && lazyDatabaseSnapshot.isAttempted() || !engineResults.getSkippedBecauseOfLicenceRules().isEmpty()) {
                object4 = ChecksRunJsonOutputHelper.createDatabaseJsonOutput(engineResults, string2, lazyDatabaseSnapshot, bl5, string11, checkSettingsConfig, n2);
                object = ((FormattedDatabaseChecksResultModel)((Object)object4)).maxSeverity;
                ((FormattedChecksReportResultModel)((Object)object3)).databaseChecks.add((FormattedDatabaseChecksResultModel)((Object)object4));
            }
            object5 = new FormattedChecksOutputSerializer().serialize((LiquibaseSerializable)object5, true).replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
            ((StringBuilder)charSequence).append((String)object5);
            object4 = ((SeverityEnum)((Object)object2)).getValue() > ((SeverityEnum)((Object)object)).getValue() ? object2 : object;
            commandResultsBuilder.getOutputStream().write(((StringBuilder)charSequence).toString().getBytes(StandardCharsets.UTF_8));
        } else {
            object4 = ChecksRunConsoleOutputHelper.outputChecksResults(commandResultsBuilder, (EngineResults<ChangeSet>)object4, engineResults, lazyDatabaseSnapshot, string2, bl5, (List<AbstractLiquibaseRule>)changeLogParser, bl2, linkedHashSet, n2);
        }
        if (checkSettingsConfig != null && !ChecksRunCommandStep.isJsonOutput(string)) {
            this.sendMessage(commandResultsBuilder, checkSettingsConfig.getUnrecognizedRulesWarningMessage());
        }
        commandResultsBuilder.getOutputStream().flush();
        int n3 = ((SeverityEnum)((Object)object4)).getExitValue();
        if (n3 != 0) {
            commandResultsBuilder.addResult("statusCode", (Object)n3);
            throw commandResultsBuilder.commandFailed("Checks run command exited with an error code of ".concat(String.valueOf(n3)), n3, true);
        }
        if (checkSettingsConfig != null) {
            checkSettingsConfig.outputWarningMessage();
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
        try {
            if (lazyDatabaseSnapshot != null) {
                lazyDatabaseSnapshot.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (database != null) {
                database.close();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private Database getDatabaseForChecks(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        block5: {
            if (string != null) {
                try {
                    string = LazyDatabaseSnapshot.createDatabaseObject(string, string3, string4, string5, string6, string7, string8);
                    if (string.getConnection() instanceof OfflineConnection) {
                        this.sendMessageToUi("INFO: Snapshot database specified. Checks executed against H2 generated SQL, which may not contain certain objects.");
                        string = new H2Database();
                        break block5;
                    }
                    this.sendMessageToUi("INFO: Checks executed against SQL generated by " + string.getConnection().getDatabaseProductName() + " at " + string2 + ".");
                }
                catch (Exception exception) {
                    string2 = "WARNING: Unable to connect to database " + string2 + ". Checks executed against H2 generated SQL, which may not contain certain objects.";
                    this.sendMessageToUi(string2);
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(string2, (Throwable)exception);
                    string = new H2Database();
                }
            } else {
                this.sendMessageToUi("INFO: No database specified. Checks executed against H2 generated SQL, which may not contain certain objects.");
                string = new H2Database();
            }
        }
        return string;
    }

    private void printLicensingMessages(List<AbstractLiquibaseRule> list, List<AbstractConfigurableRule> list2, String string, boolean bl2, boolean bl3) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        int n2 = licenseService.daysTilExpiration();
        boolean bl4 = LicenseServiceUtils.isProLicenseValid();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        List list3 = list2.stream().filter(abstractConfigurableRule -> {
            if (!((Optional)(list = abstractConfigurableRule.findParentRule(list))).isPresent()) {
                return false;
            }
            if (bl2 && !((AbstractLiquibaseRule)((Optional)((Object)list)).get()).getScope().contains((Object)ScopeEnum.CHANGELOG)) {
                return false;
            }
            if (bl3 && !((AbstractLiquibaseRule)((Optional)((Object)list)).get()).getScope().contains((Object)ScopeEnum.DATABASE)) {
                return false;
            }
            return ((AbstractLiquibaseRule)((Optional)((Object)list)).get()).getScope().contains((Object)ScopeEnum.CHANGELOG);
        }).map(abstractConfigurableRule -> abstractConfigurableRule.getShortName(list)).collect(Collectors.toList());
        boolean bl5 = list2.stream().anyMatch(abstractConfigurableRule -> abstractConfigurableRule.findParentRule(list).isPresent() && abstractConfigurableRule.findParentRule(list).get().getScope().contains((Object)ScopeEnum.DATABASE) && !bl3);
        boolean bl6 = StringUtil.isEmpty((String)string);
        if (n2 > 0) {
            if (bl2 && bl3) {
                if (bl6) {
                    this.sendMessageToUi("Executing all changelog and database checks because a valid license key was found!" + System.lineSeparator());
                } else if (!list3.isEmpty()) {
                    this.sendMessageToUi("Executing specified changelog and database checks: '" + StringUtil.join(list3, (String)"', '") + "'");
                }
            } else if (bl4 && bl2) {
                if (bl6) {
                    this.sendMessageToUi("Executing all changelog checks because a valid license key was found!" + System.lineSeparator());
                } else if (!list3.isEmpty()) {
                    this.sendMessageToUi("Executing specified changelog checks: '" + StringUtil.join(list3, (String)"', '") + "'");
                }
            } else if (bl3) {
                if (bl6) {
                    this.sendMessageToUi("Executing all database checks because a valid license key was found!" + System.lineSeparator());
                } else if (!list3.isEmpty()) {
                    this.sendMessageToUi("Executing specified database checks: '" + StringUtil.join(list3, (String)"', '") + "'");
                }
            }
            if (bl5) {
                this.sendMessageToUi("WARNING: No database checks were run. Make sure the checks-scope property includes \"database\" to run database checks. In the CLI set --checks-scope=\"changelog,database\" or set an environment variable LIQUIBASE_COMMAND_CHECKS_SCOPE=database. Learn more at https://docs.liquibase.com/quality-checks" + System.lineSeparator());
            }
            if (n2 <= 7) {
                this.sendMessageToUi("WARNING: Liquibase license key will expire on " + simpleDateFormat.format(licenseService.getExpirationDate()) + ". You will lose access access to unlimited changelog and database checks providing quality assurance and compliance.\nContact Support or Sales, or buy online at https://liquibase.com/pricing");
            }
            if (!bl4) {
                this.sendMessageToUi("No valid Liquibase license key detected!" + System.lineSeparator() + "Unlock unlimited checks with Pro license Key." + System.lineSeparator() + "Free trial key at https://liquibase.com/trial" + System.lineSeparator());
                return;
            }
        } else {
            this.sendMessageToUi("WARNING: Liquibase license key expired on " + simpleDateFormat.format(licenseService.getExpirationDate()) + ". To regain access to unlimited changelog and database checks providing quality assurance and compliance, contact Support or Sales, or buy online at https://liquibase.com/pricing" + System.lineSeparator());
        }
    }

    public static boolean isJsonOutput(String string) {
        return string.equalsIgnoreCase(ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.JSON.name());
    }

    private static boolean validateOutputFormat(String string) {
        ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT[] checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray = ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.values();
        int n2 = checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray[i2].toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void sendMessageToUi(String string) {
        Scope.getCurrentScope().getUI().sendMessage(string);
    }

    private void sendMessage(CommandResultsBuilder commandResultsBuilder, String string) {
        commandResultsBuilder.getOutputStream().write(string.getBytes());
    }

    private static boolean validChecksScope(String string2) {
        return Arrays.stream(string2.split(",")).allMatch(string -> Arrays.stream(ScopeEnum.values()).anyMatch(scopeEnum -> string.trim().equalsIgnoreCase(scopeEnum.toString())));
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Check the changelog or database for issues");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private EngineResults<ChangeSet> runChecks(List<AbstractLiquibaseRule> list, List<ChangeSet> list2, Database database, List<AbstractConfigurableRule> list3, boolean bl2, Level level) {
        if (list3 != null) {
            return (EngineResults)Scope.child(Collections.singletonMap(SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG.getName(), level), () -> this.runCheck(list, list2, database, list3, bl2));
        }
        return new EngineResults<ChangeSet>();
    }

    private EngineResults<DatabaseObject> runDatabaseChecks(List<AbstractLiquibaseRule> list, LazyDatabaseSnapshot lazyDatabaseSnapshot, List<AbstractConfigurableRule> list2) {
        if (list2 != null) {
            return this.runDatabaseCheck(list, lazyDatabaseSnapshot, list2);
        }
        return new EngineResults<DatabaseObject>();
    }

    private EngineResults<DatabaseObject> runDatabaseCheck(List<AbstractLiquibaseRule> iterator, LazyDatabaseSnapshot object, List<AbstractConfigurableRule> list) {
        Object object2 = new Facts();
        if (object != null) {
            ((Facts)object2).put(FactEnum.DATABASE_SNAPSHOT.toString(), object);
        }
        iterator = new Rules(iterator.toArray());
        object = new DatabaseQualityChecksRulesEngine(list);
        ((QualityChecksRulesEngine)object).fire((Rules)((Object)iterator), (Facts)object2);
        iterator = ((QualityChecksRulesEngine)object).getResults();
        list = ((QualityChecksRulesEngine)object).getSkippedRules();
        object2 = new LinkedHashMap(iterator.size());
        for (Map.Entry entry : iterator.entrySet()) {
            ((HashMap)object2).put(entry.getKey(), new LiquibaseQualityCheckResult((List)entry.getValue(), null, ((QualityChecksRulesEngine)object).getExecutedRules(), null));
        }
        return new EngineResults<DatabaseObject>((List<RuleCombination>)list, (LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult>)object2);
    }

    private EngineResults<ChangeSet> runCheck(List<AbstractLiquibaseRule> list, List<ChangeSet> object2, Database object3, List<AbstractConfigurableRule> list2, boolean bl2) {
        Facts facts = new Facts();
        facts.put(FactEnum.CHANGESETS.toString(), object2);
        facts.put(FactEnum.DATABASE.toString(), object3);
        facts.put(FactEnum.CHECK_ROLLBACKS.toString(), bl2);
        object3 = new Rules(list.toArray());
        ChangesetQualityChecksRulesEngine changesetQualityChecksRulesEngine = new ChangesetQualityChecksRulesEngine(list2);
        changesetQualityChecksRulesEngine.registerRuleListener(new ChecksRunCommandStep$1(this));
        changesetQualityChecksRulesEngine.fire((Rules)object3, facts);
        object3 = changesetQualityChecksRulesEngine.getSkippedRules();
        object2 = new LinkedHashMap(object2.size());
        for (Map.Entry entry : changesetQualityChecksRulesEngine.getResults().entrySet()) {
            List<LiquibaseRuleResult> list3 = (List<LiquibaseRuleResult>)entry.getValue();
            Object object4 = new AtomicBoolean(false);
            object4 = list3.stream().filter(arg_0 -> ChecksRunCommandStep.lambda$runCheck$14((AtomicBoolean)object4, arg_0)).collect(Collectors.toList());
            List<String> list4 = list3.stream().filter(LiquibaseRuleResult::hasSqlParseFailures).skip(1L).map(liquibaseRuleResult -> this.getSkippedRuleName(liquibaseRuleResult.getRule(), liquibaseRuleResult.getDynamicRule())).collect(Collectors.toList());
            list3 = list3.stream().filter(LiquibaseRuleResult::hasInvalidChangelogFileTypeFailures).filter(object -> {
                object = ((LiquibaseRuleResult)object).getRuleShortName(false);
                return list2.stream().filter(arg_0 -> ChecksRunCommandStep.lambda$null$16(list, (String)object, arg_0)).findFirst().map(AbstractConfigurableRule::isEnabled).orElse(Boolean.FALSE);
            }).collect(Collectors.toList());
            List<RuleCombination> list5 = changesetQualityChecksRulesEngine.getExecutedRules().stream().filter(ruleCombination -> !list4.contains(this.getSkippedRuleName((AbstractLiquibaseRule)ruleCombination.rule, ruleCombination.configurableRule))).collect(Collectors.toList());
            object2.put(entry.getKey(), new LiquibaseQualityCheckResult((List<LiquibaseRuleResult>)object4, list4, list5, list3));
        }
        return new EngineResults<ChangeSet>((List<RuleCombination>)object3, object2);
    }

    private String getSkippedRuleName(AbstractLiquibaseRule abstractLiquibaseRule, AbstractConfigurableRule abstractConfigurableRule) {
        if (abstractConfigurableRule instanceof DynamicRule) {
            return ((DynamicRule)abstractConfigurableRule).getShortName();
        }
        if (abstractLiquibaseRule.getShortName() != null) {
            return abstractLiquibaseRule.getShortName();
        }
        return abstractLiquibaseRule.getName();
    }

    private static /* synthetic */ boolean lambda$null$16(List list, String string, AbstractConfigurableRule abstractConfigurableRule) {
        return abstractConfigurableRule.getShortName(list).equals(string);
    }

    private static /* synthetic */ boolean lambda$runCheck$14(AtomicBoolean atomicBoolean, LiquibaseRuleResult liquibaseRuleResult) {
        if (liquibaseRuleResult.hasSqlParseFailures()) {
            return !atomicBoolean.getAndSet(true);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$null$5(Integer n2, SeverityEnum severityEnum) {
        return severityEnum.getExitValue() == n2.intValue();
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to a Liquibase changelog file.  One of --changelog-file or --url is required.").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_SCOPE_ARG = commandBuilder.argument("checksScope", String.class).defaultValue((Object)ScopeEnum.CHANGELOG.toString().toLowerCase()).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validChecksScope((String)(object = (String)object))) {
                object = "\nWARNING:  Check scope value '" + (String)object + "' is not valid.  Valid check scope values include: " + StringUtil.join((Object[])ScopeEnum.values(), (String)", ", scopeEnum -> scopeEnum.toString().toLowerCase());
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description("The Liquibase component to run checks against, which can be a comma separated list").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_OUTPUT_FORMAT_ARG = commandBuilder.argument("format", String.class).defaultValue((Object)ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.TXT.name()).description(ProStringUtil.markWithPro("Option to create JSON output")).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validateOutputFormat((String)(object = String.valueOf(object)))) {
                object = "\nWARNING:  The format value '" + (String)object + "' is not valid.  Valid values include: 'json' or 'txt'";
                throw new IllegalArgumentException((String)object);
            }
            if (((String)object).equalsIgnoreCase("json")) {
                if (!LicenseServiceUtils.isProLicenseValid()) {
                    object = "checks run --format=".concat(String.valueOf(object));
                    object = String.format(coreBundle.getString("no.pro.license.found"), object);
                    throw new IllegalArgumentException((String)object);
                }
                return ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.JSON.name();
            }
            return ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.TXT.name();
        }).build();
        CHECKS_INTEGRATION_ARG = commandBuilder.argument("checksIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing checks run").build();
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).description("Comma-separated list of one or more enabled checks to run. Checks to exclude can be prefixed with the ! character. If no checks are specified, all enabled checks will run. Example: --check-name=shortname1,shortname2,!shortname3").build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL.  One of --changelog-file or --url is required.").build();
        SCHEMAS_ARG = commandBuilder.argument("schemas", String.class).description("The schemas to check when checks-scope contains 'database'").build();
        DEFAULT_SCHEMA_NAME_ARG = commandBuilder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = commandBuilder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = commandBuilder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = commandBuilder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        VERBOSE_ARG = commandBuilder.argument("verbose", Boolean.class).defaultValue((Object)Boolean.FALSE).setValueHandler(ValueHandlerUtil::booleanValueHandler).description("Verbose flag with optional values of 'True' or 'False'. The default is 'False'.").build();
        CACHE_CHANGELOG_FILE_CONTENTS = commandBuilder.argument("cacheChangelogFileContents", Boolean.class).description("If true, sqlFile change type contents will be cached in memory to improve performance, at the cost of higher memory usage. To reduce memory usage, set this to false.").defaultValue((Object)Boolean.TRUE).build();
        LABELS_ARG = commandBuilder.argument("labelFilter", String.class).addAlias("labels").description("Changeset labels to match").build();
        CONTEXTS_ARG = commandBuilder.argument("contextFilter", String.class).addAlias("contexts").description("Changeset contexts to match").build();
        CHECK_ROLLBACKS_ARG = commandBuilder.argument("checkRollbacks", Boolean.class).addAlias("checkRollback").defaultValue((Object)Boolean.FALSE).setValueHandler(ValueHandlerUtil::booleanValueHandler).description("Allow changeset's rollback code to be analyzed for compliance with currently enabled quality checks.").build();
        CHECKS_SETTINGS_FILE_DTO = commandBuilder.argument("checksSettingsFileDto", CheckSettingsConfig.class).description("An already loaded CheckSettingsConfig object").hidden().build();
        CHECKS_OUTPUT_ARG = commandBuilder.argument("checksOutput", String.class).description("Specify which parts of the checks run output should be shown; options: " + StringUtil.join((Object[])ChecksOutput.values(), (String)", ", Object::toString)).defaultValue((Object)ChecksOutput.all.toString()).build();
        SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG = commandBuilder.argument("sqlParserExceptionLogAtLevel", Level.class).description("The log level that SQL parser exceptions should be logged at").defaultValue((Object)Level.FINE).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            return Level.parse(object.toString().toUpperCase());
        }).hidden().build();
        SQL_PARSER_FAIL_SEVERITY = commandBuilder.argument("sqlParserFailSeverity", Integer.class).description("The severity that a check which fails due to a SQL parse error will exit with. If not set, use the severity of the configured check. Available values are: " + StringUtil.join((int[])Arrays.stream(SeverityEnum.values()).mapToInt(SeverityEnum::getExitValue).sorted().toArray(), (String)", ")).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            object = Integer.valueOf(String.valueOf(object));
            if (!Arrays.stream(SeverityEnum.values()).anyMatch(arg_0 -> ChecksRunCommandStep.lambda$null$5((Integer)object, arg_0))) {
                throw new IllegalArgumentException("The sqlParserFailSeverity must be set to either null (the default value) or one of the allowed values: " + StringUtil.join((int[])Arrays.stream(SeverityEnum.values()).mapToInt(SeverityEnum::getExitValue).sorted().toArray(), (String)", "));
            }
            return object;
        }).build();
    }
}

