/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.reports.DriftReportParameters;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.pro.packaged.qd;

public class DriftReport {
    private static final String TEMPLATE_RESOURCE_ROOT = "liquibase/html";
    private static final String TEMPLATE_NAME = "drift-report.html";
    private final String name;
    private final String path;
    private final DriftReportParameters driftReportParameters;

    public DriftReport(String string, String string2, DriftReportParameters driftReportParameters) {
        this.name = string;
        this.path = string2;
        this.driftReportParameters = driftReportParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public DriftReportParameters getDriftReportParameters() {
        return this.driftReportParameters;
    }

    public void generateReport() {
        try {
            DriftReport driftReport = this;
            driftReport.writeHtml(driftReport.buildDirectories());
            Scope.getCurrentScope().getUI().sendMessage(String.format("Drift report '%s' generated successfully!", this.getName()));
            return;
        }
        catch (Exception exception) {
            throw new LiquibaseException("Could not generate report!", (Throwable)exception);
        }
    }

    private Path buildDirectories() {
        try {
            Path path = this.getFullPath();
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            return path;
        }
        catch (IOException iOException) {
            throw new LiquibaseException(String.format("Could not create report directory for report: %s at path: %s! Make sure you have provided a valid filename, path and have permissions to create files.", this.getName(), this.getPath()), (Throwable)iOException);
        }
    }

    public Path getFullPath() {
        Path path = this.getName().endsWith(".html") ? Paths.get(this.getPath(), this.getName()) : Paths.get(this.getPath(), String.format("%s.%s", this.getName(), "html"));
        return path;
    }

    private void writeHtml(Path path) {
        Object object = new HashSet<String>();
        object.add(TEMPLATE_NAME);
        object = new qd((Set<String>)object, TEMPLATE_RESOURCE_ROOT).b(TEMPLATE_NAME);
        StringWriter stringWriter = new StringWriter();
        object.a((Writer)stringWriter, this.getDriftReportParameters()).flush();
        Files.write(path, stringWriter.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

