/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.config.DriftConfiguration;
import com.datical.liquibase.ext.reports.DatabaseObjectReportValue;
import java.util.Date;
import java.util.List;
import liquibase.database.jvm.JdbcConnection;

public class DriftReportParameters {
    private final String reportName;
    private final Date date;
    private final String targetUrl;
    private final String sourceUrl;
    private final String createdByUser;
    private final String hostName;
    private final List<DatabaseObjectReportValue> missing;
    private final List<DatabaseObjectReportValue> unexpected;
    private final List<DatabaseObjectReportValue> changed;
    private final String jsonMissing;
    private final String jsonUnexpected;
    private final String jsonChanged;
    private final String numberMissing;
    private final String numberUnexpected;
    private final String numberChanged;
    private final boolean showMissing;
    private final boolean showUnexpected;
    private final boolean showChanged;
    private final String path;
    private final String commandArgs;
    private final String reportMode;

    public DriftReportParameters(String string, String string2, String string3, String string4, String string5, List<DatabaseObjectReportValue> list, List<DatabaseObjectReportValue> list2, List<DatabaseObjectReportValue> list3, String string6, String string7, String string8, String string9, String string10, String string11, boolean bl2, boolean bl3, boolean bl4, String string12, String string13, String string14) {
        this.reportName = string;
        this.reportMode = string14;
        this.date = new Date();
        this.targetUrl = string2;
        this.sourceUrl = string3;
        this.createdByUser = string4;
        this.hostName = string5;
        this.missing = list;
        this.unexpected = list2;
        this.changed = list3;
        this.jsonMissing = string6;
        this.jsonUnexpected = string7;
        this.jsonChanged = string8;
        this.numberMissing = string9;
        this.numberUnexpected = string10;
        this.numberChanged = string11;
        this.showMissing = bl2;
        this.showUnexpected = bl3;
        this.showChanged = bl4;
        this.commandArgs = string13;
        this.path = string12;
    }

    public String getReportName() {
        return this.reportName;
    }

    public Date getDate() {
        return this.date;
    }

    public String getTargetUrl() {
        return JdbcConnection.sanitizeUrl((String)this.targetUrl);
    }

    public String getSourceUrl() {
        return JdbcConnection.sanitizeUrl((String)this.sourceUrl);
    }

    public String getCreatedByUser() {
        return this.createdByUser;
    }

    public String getHostName() {
        return this.hostName;
    }

    public List<DatabaseObjectReportValue> getMissing() {
        return this.missing;
    }

    public List<DatabaseObjectReportValue> getUnexpected() {
        return this.unexpected;
    }

    public List<DatabaseObjectReportValue> getChanged() {
        return this.changed;
    }

    public String getNumberMissing() {
        return this.numberMissing;
    }

    public String getNumberUnexpected() {
        return this.numberUnexpected;
    }

    public String getNumberChanged() {
        return this.numberChanged;
    }

    public boolean getShowMissing() {
        return this.showMissing;
    }

    public boolean getShowUnexpected() {
        return this.showUnexpected;
    }

    public boolean getShowChanged() {
        return this.showChanged;
    }

    public String getCommandArgs() {
        return this.commandArgs;
    }

    public int getMissingSeverity() {
        return (Integer)DriftConfiguration.MISSING_SEVERITY.getCurrentValue();
    }

    public int getChangedSeverity() {
        return (Integer)DriftConfiguration.CHANGED_SEVERITY.getCurrentValue();
    }

    public int getUnexpectedSeverity() {
        return (Integer)DriftConfiguration.UNEXPECTED_SEVERITY.getCurrentValue();
    }

    public String getPath() {
        if (this.path != null) {
            if (this.path.equals(".")) {
                return "./";
            }
        } else {
            return "";
        }
        return this.path;
    }

    public String getJsonMissing() {
        return this.jsonMissing;
    }

    public String getJsonUnexpected() {
        return this.jsonUnexpected;
    }

    public String getJsonChanged() {
        return this.jsonChanged;
    }

    public String getReportMode() {
        return this.reportMode;
    }
}

