/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.api;

import com.datical.liquibase.ext.command.checks.ChecksOutput;
import java.util.Arrays;
import java.util.LinkedHashSet;

public enum SeverityEnum {
    BLOCKER(Integer.MAX_VALUE, 4),
    CRITICAL(300, 3),
    MAJOR(200, 2),
    MINOR(100, 1),
    INFO(Integer.MIN_VALUE, 0);

    private final int value;
    private final int exitValue;

    private SeverityEnum(int n3, int n4) {
        this.value = n3;
        this.exitValue = n4;
    }

    public final int getValue() {
        return this.value;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final boolean shouldOutputToChecksRunConsole(LinkedHashSet<ChecksOutput> linkedHashSet) {
        if (linkedHashSet.contains((Object)ChecksOutput.all) || linkedHashSet.contains((Object)ChecksOutput.issues)) {
            return true;
        }
        if (linkedHashSet.stream().anyMatch(ChecksOutput.SEVERITY_RELATED_KEYS::contains)) {
            return linkedHashSet.contains((Object)ChecksOutput.valueOf("issues" + this.exitValue));
        }
        return false;
    }

    public static SeverityEnum fromExitValue(int n2) {
        return Arrays.stream(SeverityEnum.values()).filter(severityEnum -> severityEnum.getExitValue() == n2).findFirst().orElse(null);
    }
}

