/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.appdba.sqlplus.change.exception.DaticalSpErrorLogException;
import com.datical.liquibase.ext.config.SqlplusConfiguration;
import com.datical.liquibase.ext.config.SqlplusConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.NativeExecutorRunner$ConfigFile;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.logging.Logger;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlPlusRunner
extends NativeExecutorRunner {
    private File outFile = null;
    private File spoolFile = null;
    private Boolean keepTempFile = Boolean.FALSE;
    private Boolean tempOverwrite = Boolean.TRUE;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private Integer timeout;
    private String sqlerror;
    private Boolean createSpool = Boolean.TRUE;
    private File sqlPlusExec;
    private boolean ignoreSpErrorLog = false;
    private static final String DATICAL_SPERRORLOG = "DATICAL_SPERRORLOG";
    private String errorLoggingIdentifier;
    private static final String EXECUTABLE_NAME = "sqlplus";

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public SqlPlusRunner() {
    }

    @Override
    public String getIntegrationDisplayName() {
        return "SQL Plus";
    }

    public SqlPlusRunner(ChangeSet changeSet, Sql[] sqlArray, boolean bl2) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
        this.errorLoggingIdentifier = UUID.randomUUID().toString();
        this.ignoreSpErrorLog = bl2;
    }

    protected List<String> createFinalCommandArray(Database object) {
        this.loadSqlplusProperties();
        List list = super.createFinalCommandArray(object);
        try {
            this.writeSql((Database)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)SqlplusConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        if (!list.contains("-L")) {
            list.add("-L");
        }
        object = this.buildConnectionString((Database)object);
        list.add(object);
        if (this.outFile != null) {
            list.add("@" + this.outFile.getAbsolutePath());
        }
        object = StringUtil.join((Collection)list, (String)" ").replaceAll("^(.*?) (.*?)/\"(.*)\"@(.)", "$1 ******/******@$4");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS command:\n".concat(String.valueOf(object)));
        return list;
    }

    protected void processResult(int n2, String string3, String string2, Database database) {
        try {
            List<?> list = this.processResultFromDaticalSpErrorLog(database);
            StringBuilder stringBuilder = new StringBuilder();
            if (list == null || list.isEmpty()) {
                super.processResult(n2, string3, string2, database);
                return;
            }
            stringBuilder.append("Error executing changeset '");
            stringBuilder.append(this.changeSet.toString());
            stringBuilder.append("'\n");
            for (String string3 : list) {
                stringBuilder.append(string3.toString().concat("\n"));
            }
            throw new DaticalSpErrorLogException(stringBuilder.toString());
        }
        finally {
            this.dropDaticalSpErrorLog(database);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(Database object) {
        block17: {
            try {
                this.createDaticalSpErrorLogIfNeeded((Database)object);
            }
            catch (DaticalSpErrorLogException daticalSpErrorLogException) {
                Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(daticalSpErrorLogException.getMessage());
            }
            try {
                this.finalCommandArray = this.createFinalCommandArray((Database)object);
                super.executeCommand(object);
                if (this.spoolFile == null) break block17;
            }
            catch (TimeoutException timeoutException) {
                try {
                    this.ignoreSpErrorLog = true;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.processResult(0, null, null, (Database)object);
                    object = timeoutException.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlplus executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlplus.conf file, the LIQUIBASE_SQLPLUS_TIMEOUT Enviroment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sql-plus-integration.html." + System.lineSeparator();
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                    Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning((String)object);
                    throw new LiquibaseException((Throwable)timeoutException);
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw illegalArgumentException;
                    }
                    catch (Exception exception) {
                        throw new LiquibaseException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    if (this.spoolFile != null) {
                        try {
                            this.captureSpoolOutputInLog();
                        }
                        catch (IOException iOException) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS was unable to read the spool file located at " + this.spoolFile.getAbsolutePath());
                        }
                    }
                    if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            try {
                this.captureSpoolOutputInLog();
            }
            catch (IOException iOException) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS was unable to read the spool file located at " + this.spoolFile.getAbsolutePath());
            }
        }
        if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
            return;
        }
    }

    private void createDaticalSpErrorLogIfNeeded(Database object) {
        if (this.ignoreSpErrorLog) {
            return;
        }
        String string = this.getLiquibaseCatalogName((Database)object);
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        try {
            object = String.format("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s' AND TABLE_NAME='%s'", string, DATICAL_SPERRORLOG);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement((String)object), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(databaseException.getMessage());
            throw new DaticalSpErrorLogException(String.format("Can't check if table: %s exists due to an error", DATICAL_SPERRORLOG), databaseException);
        }
        if (object != null && !object.isEmpty()) {
            try {
                jdbcExecutor.execute((SqlStatement)new RawSqlStatement(String.format("DELETE FROM %s.%s", string, DATICAL_SPERRORLOG)));
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to clear rows from table: %s.%s due to an error. Table is locked or the user has insufficient privileges", string, DATICAL_SPERRORLOG));
            }
        }
        try {
            object = String.format("CREATE TABLE %s.%s (username VARCHAR(256), timestamp TIMESTAMP, script VARCHAR(256), identifier VARCHAR(256), message CLOB, statement CLOB)", string, DATICAL_SPERRORLOG);
            jdbcExecutor.execute((SqlStatement)new RawSqlStatement((String)object));
            return;
        }
        catch (DatabaseException databaseException) {
            if (databaseException.getMessage().contains("insufficient privileges")) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to create table: %s.%s due to an error. Insufficient privileges", string, DATICAL_SPERRORLOG));
                return;
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to create table: %s.%s due to an error. The table may already exist or you may not have privileges to create it.", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    private void dropDaticalSpErrorLog(Database database) {
        if (this.ignoreSpErrorLog) {
            return;
        }
        String string = this.getLiquibaseCatalogName(database);
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(database);
        try {
            jdbcExecutor.execute((SqlStatement)new RawSqlStatement(String.format("DROP TABLE %s.%s", string, DATICAL_SPERRORLOG)));
            return;
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to drop table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the DROP TABLE privilege. ", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    private String getLiquibaseCatalogName(Database database) {
        return "\"" + database.getLiquibaseCatalogName() + "\"";
    }

    private List<?> processResultFromDaticalSpErrorLog(Database object) {
        if (this.ignoreSpErrorLog) {
            return Collections.emptyList();
        }
        String string = this.getLiquibaseCatalogName((Database)object);
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(object);
        object = null;
        try {
            String string2 = String.format("select CONCAT(CONCAT('Query: ', STATEMENT), CONCAT('>>> Has an error: ', MESSAGE)) as ERROR_MESSAGE from %s.%s WHERE IDENTIFIER='%s'", string, DATICAL_SPERRORLOG, this.errorLoggingIdentifier);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement(string2), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to query table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the correct privileges. ", string, DATICAL_SPERRORLOG));
        }
        return object;
    }

    private void loadSqlplusProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner$ConfigFile.SQLPLUS);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        this.addPropertiesToMdc();
        SqlPlusRunner sqlPlusRunner = this;
        sqlPlusRunner.handleSqlplusExecutable(sqlPlusRunner.sqlPlusExec);
        SqlPlusRunner sqlPlusRunner2 = this;
        sqlPlusRunner2.handleTimeout(sqlPlusRunner2.timeout);
        this.logProperties();
    }

    private void addPropertiesToMdc() {
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusKeepTemp", String.valueOf(this.keepTempFile));
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusKeepTempPath", this.tempPath);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusKeepTempName", this.tempName);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusTempOverwrite", String.valueOf(this.tempOverwrite));
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.sqlplus.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property 'liquibase.sqlplus.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sql-plus-integration.html");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file name value of '" + this.tempName + "'");
        }
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().addMdcValue("liquibaseSqlplusArgs", string);
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim((String)string, (String)" ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            Scope.getCurrentScope().addMdcValue("liquibaseSqlplusTimeout", String.valueOf(n2));
            NativeRunnerUtil.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a timeout of '" + n2 + "'");
        }
    }

    private void handleSqlplusExecutable(File file) {
        if (file == null) {
            return;
        }
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusPath", file.toString());
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'sqlplus' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.sqlplus.conf file.\nPlease specify the correct path for the 'sqlplus' executable, or modify your PATH so that it can be located.  Learn more at http://docs.liquibase.com.");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlplus' executable in the liquibase.sqlplus.conf file at " + file.getAbsolutePath() + " cannot be executed");
        }
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'sqlplus' executable located at:  '" + file.getCanonicalPath() + "'");
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
    }

    private void setupConfProperties(Properties object) {
        if (((Properties)object).containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties((Properties)object, SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp"));
        }
        if (((Properties)object).containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = ((Properties)object).getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (((Properties)object).containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = NativeRunnerUtil.getBooleanFromProperties((Properties)object, SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (((Properties)object).containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = ((Properties)object).getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (((Properties)object).containsKey("liquibase.sqlplus.path")) {
            this.sqlPlusExec = new File(((Properties)object).getProperty("liquibase.sqlplus.path"));
        }
        if (((Properties)object).containsKey("liquibase.sqlplus.timeout")) {
            this.timeout = this.determineTimeout((Properties)object);
        }
        if (((Properties)object).containsKey("liquibase.sqlplus.sqlerror")) {
            this.sqlerror = ((Properties)object).getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("sqlerror"));
        }
        if (((Properties)object).containsKey("liquibase.sqlplus.args")) {
            this.handleArgs(((Properties)object).getProperty("liquibase.sqlplus.args"));
        }
        if (((Properties)object).containsKey("liquibase.sqlplus.createSpool")) {
            if (!((String)(object = ((Properties)object).getProperty("liquibase.sqlplus.createSpool").toLowerCase())).equals("true") && !((String)object).equals("false")) {
                throw new IllegalArgumentException("Illegal value '" + (String)object + "' for createSpool. Valid values are 'TRUE' or 'FALSE'");
            }
            this.createSpool = Boolean.parseBoolean((String)object);
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.keepTempFile = SqlplusConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)SqlplusConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        this.tempName = SqlplusConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)SqlplusConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = SqlplusConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)SqlplusConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.tempOverwrite = SqlplusConfiguration.TEMP_OVERWRITE.getCurrentValue() != null ? (Boolean)SqlplusConfiguration.TEMP_OVERWRITE.getCurrentValue() : this.tempOverwrite;
        this.timeout = SqlplusConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)SqlplusConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        this.sqlerror = SqlplusConfiguration.SQLERROR.getCurrentValue() != null ? (String)SqlplusConfiguration.SQLERROR.getCurrentValue() : this.sqlerror;
        Boolean bl2 = this.createSpool = SqlplusConfiguration.CREATE_SPOOL.getCurrentValue() != null ? (Boolean)SqlplusConfiguration.CREATE_SPOOL.getCurrentValue() : this.createSpool;
        if (SqlplusConfiguration.PATH.getCurrentValue() != null) {
            this.sqlPlusExec = new File((String)SqlplusConfiguration.PATH.getCurrentValue());
        }
        if (SqlplusConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)SqlplusConfiguration.ARGS.getCurrentValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSql(Database object) {
        BufferedWriter bufferedWriter;
        block26: {
            NativeToolFileCreator nativeToolFileCreator;
            if (this.sqlStrings == null) return;
            if (this.sqlStrings.length == 0) {
                return;
            }
            Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
            boolean bl2 = true;
            Object object2 = this.changeSet.getRunWithSpoolFile();
            if (object2 == null) {
                object2 = this.tempName;
            } else {
                if (!NativeToolFileCreator.EXTENSION_PATTERN.matcher((CharSequence)object2).matches()) {
                    object2 = (String)object2 + ".lst";
                }
                bl2 = false;
            }
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).info("Using spool file name '" + (String)object2 + "'");
            logger.info("Creating the SQL run script");
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).info("Executing 'sqlplus' with a createSpool value of '" + this.createSpool + "'");
            Scope.getCurrentScope().addMdcValue("liquibaseSqlplusCreateSpool", this.createSpool.toString());
            if (Boolean.TRUE.equals(this.createSpool)) {
                try {
                    nativeToolFileCreator = new NativeToolFileCreator(this.changeSet, (String)object2, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlplusConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlplusConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
                    this.spoolFile = nativeToolFileCreator.generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.spool, bl2);
                    Scope.getCurrentScope().addMdcValue("liquibaseSqlplusSpoolFile", this.spoolFile.toString());
                }
                catch (IOException iOException) {
                    throw new UnexpectedLiquibaseException((Throwable)iOException);
                }
                logger.info("Using spool file name '" + this.spoolFile.toString() + "'");
            } else {
                logger.info("Liquibase will not create spool files");
                this.spoolFile = null;
            }
            try {
                nativeToolFileCreator = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlplusConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlplusConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
                this.outFile = nativeToolFileCreator.generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
            int n2 = this.isAddWhenever();
            object = this.getLiquibaseCatalogName((Database)object);
            bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            object2 = null;
            try {
                Object sql;
                bufferedWriter.write("SET ECHO ON\n");
                bufferedWriter.write("SET DEFINE OFF\n");
                bufferedWriter.write(String.format("SET ERRORLOGGING ON TABLE %s.%s TRUNCATE IDENTIFIER '%s' %n", object, DATICAL_SPERRORLOG, this.errorLoggingIdentifier));
                if (n2 != 0) {
                    if (StringUtil.isNotEmpty((String)this.sqlerror)) {
                        logger.info("Adding WHENEVER SQLERROR CLAUSE of " + this.sqlerror);
                        if (!this.sqlerror.trim().endsWith(";")) {
                            this.sqlerror = this.sqlerror + ";";
                        }
                        bufferedWriter.write(this.sqlerror + "\n");
                    } else {
                        bufferedWriter.write("WHENEVER SQLERROR EXIT FAILURE;\n");
                    }
                }
                if (this.spoolFile != null) {
                    bufferedWriter.write("SPOOL \"" + this.spoolFile.getAbsolutePath() + "\"\n");
                }
                bufferedWriter.write("SET SQLBLANKLINES ON\n\n");
                object = this.sqlStrings;
                int n3 = this.sqlStrings.length;
                for (n2 = 0; n2 < n3 && !this.warnOnSpoolStatements((Sql)(sql = object[n2])); ++n2) {
                }
                this.writeSqlStrings(bufferedWriter);
                object = this.getEndDelimiter();
                if (object != null && ((String)object).equals("\n/$")) {
                    bufferedWriter.write("/\n");
                }
                bufferedWriter.write("EXIT;\n");
                if (bufferedWriter == null) return;
                if (object2 == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    object2 = throwable;
                    throw object;
                }
                catch (Throwable throwable2) {
                    if (bufferedWriter == null) throw throwable2;
                    if (object2 == null) {
                        bufferedWriter.close();
                        throw throwable2;
                    }
                    try {
                        bufferedWriter.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object2).addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
            }
            try {
                bufferedWriter.close();
                return;
            }
            catch (Throwable throwable) {
                ((Throwable)object2).addSuppressed(throwable);
                return;
            }
        }
        bufferedWriter.close();
    }

    private boolean warnOnSpoolStatements(Sql stringArray) {
        stringArray = stringArray.toSql().split("\n");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].toLowerCase().contains("spool")) continue;
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning("SPOOL statements were detected in your script for changeset " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent sqlplus spool output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    private boolean isAddWhenever() {
        boolean bl2 = true;
        Sql[] sqlArray = this.sqlStrings;
        int n2 = this.sqlStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!sqlArray[i2].toSql().toLowerCase().startsWith("whenever")) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private void captureSpoolOutputInLog() {
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        if (!this.spoolFile.exists()) {
            logger.warning("Unable to locate spool output file " + this.spoolFile.getAbsolutePath());
            return;
        }
        logger.info("Writing spool output to log");
        Throwable throwable = null;
        try (BufferedReader bufferedReader = Files.newBufferedReader(this.spoolFile.toPath());){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                logger.info(string);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        logger.info("\n");
        logger.info("Spool output written to log");
    }

    protected String buildConnectionString(Database object) {
        Object object2;
        if (object == null) {
            return null;
        }
        object = object.getConnection();
        String string = "";
        String string2 = "";
        if (object instanceof ProJdbcConnection) {
            object2 = (ProJdbcConnection)((Object)object);
            string = ((ProJdbcConnection)((Object)object2)).getUsername();
            if (string == null) {
                string = object.getConnectionUserName();
            }
            string = StringUtil.trimToEmpty((String)string);
            string2 = StringUtil.trimToEmpty((String)((ProJdbcConnection)((Object)object2)).getPassword());
            if (string2.equals("")) {
                string = "";
            } else {
                string2 = "\"" + string2 + "\"";
            }
        }
        if (((Matcher)(object = OracleDatabase.PROXY_USER_PATTERN.matcher((CharSequence)(object2 = object.getURL())))).matches()) {
            string = string + "[" + ((Matcher)object).group(1) + "]";
        }
        object = object2.split("jdbc:oracle:(.*)@")[1];
        return string + "/" + string2 + "@" + (String)object;
    }
}

