/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractFormattedChangelogRewriter;
import java.io.IOException;
import java.io.InputStream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.util.StreamUtil;

public class FormattedSqlChangelogRewriter
extends AbstractFormattedChangelogRewriter {
    @Override
    protected String getSingleLineCommentSequence() {
        return "\\-\\-";
    }

    @Override
    protected String getFirstLine() {
        return "liquibase formatted sql";
    }

    @Override
    protected String getSingleLineCommentOneCharacter() {
        return "-";
    }

    @Override
    protected String getSequenceName() {
        return "SQL";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean supports(String object) {
        try {
            object = Scope.getCurrentScope().getResourceAccessor().getExisting((String)object).openInputStream();
            Throwable throwable = null;
            try {
                String string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
                boolean bl2 = StreamUtil.readStreamAsString((InputStream)object, (String)string).toLowerCase().contains(this.getFirstLine());
                return bl2;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new LiquibaseException((Throwable)iOException);
        }
    }
}

