/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter$MOD_TYPE;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.IncludeAllFilter;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class XMLChangelogRewriter
extends AbstractChangelogRewriter {
    private static final String XML_CHANGE_SET_REGEX = "(<changeSet [^>]*+>.*?$)";
    private static final Pattern XML_CHANGE_SET_PATTERN = Pattern.compile("(<changeSet [^>]*+>.*?$)", 40);
    private static final String XML_CHANGE_SET_IGNORE_REGEX = ".*?<changeSet.*?ignore=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_CHANGE_SET_IGNORE_PATTERN = Pattern.compile(".*?<changeSet.*?ignore=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_CHANGE_SET_DBMS_REGEX = ".*?<changeSet.*?dbms=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_CHANGE_SET_DBMS_PATTERN = Pattern.compile(".*?<changeSet.*?dbms=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_CHANGE_SET_ID_REGEX = " id=\"(.*?)\"";
    private static final Pattern XML_CHANGE_SET_ID_PATTERN = Pattern.compile(" id=\"(.*?)\"", 40);
    private static final String XML_CHANGE_SET_AUTHOR_REGEX = " author=\"(.*?)\"";
    private static final Pattern XML_CHANGE_SET_AUTHOR_PATTERN = Pattern.compile(" author=\"(.*?)\"", 40);
    private static final String XML_LABELS_REGEX = " labels=\"(.*?)\"";
    private static final Pattern XML_LABELS_PATTERN = Pattern.compile(" labels=\"(.*?)\"", 40);
    private static final String XML_CONTEXT_REGEX = " context=\"(.*?)\"";
    private static final Pattern XML_CONTEXT_PATTERN = Pattern.compile(" context=\"(.*?)\"", 2);
    private static final String XML_CONTEXT_FILTER_REGEX = " contextFilter=\"(.*?)\"";
    private static final Pattern XML_CONTEXT_FILTER_PATTERN = Pattern.compile(" contextFilter=\"(.*?)\"", 2);
    private static final String XML_DATABASECHANGELOG_REGEX = ".*?<databaseChangeLog.*?logicalFilePath=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_DATABASECHANGELOG_PATTERN = Pattern.compile(".*?<databaseChangeLog.*?logicalFilePath=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_REGEX = "(<include .*?[^>]*+>)";
    private static final Pattern XML_INCLUDE_PATTERN = Pattern.compile("(<include .*?[^>]*+>)", 40);
    private static final String XML_INCLUDE_FILE_REGEX = ".*?file=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_INCLUDE_FILE_PATTERN = Pattern.compile(".*?file=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_IGNORE_REGEX = "<include .*?ignore=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_INCLUDE_IGNORE_PATTERN = Pattern.compile("<include .*?ignore=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_ALL_IGNORE_REGEX = "<includeAll .*?ignore=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_INCLUDE_ALL_IGNORE_PATTERN = Pattern.compile("<includeAll .*?ignore=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_ALL_REGEX = "<includeAll (.*?)>";
    private static final Pattern XML_INCLUDE_ALL_PATTERN = Pattern.compile("<includeAll (.*?)>", 40);
    private static final String XML_INCLUDE_ALL_PATH_REGEX = ".*?path=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_PATH_PATTERN = Pattern.compile(".*?path=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_FILTER_REGEX = ".*?filter=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_FILTER_PATTERN = Pattern.compile(".*?filter=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_RELATIVE_TO_CHANGELOG_FILE_REGEX = ".*?relativeToChangelogFile=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_RELATIVE_TO_CHANGELOG_FILE_PATTERN = Pattern.compile(".*?relativeToChangelogFile=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_ERROR_IF_MISSING_OR_EMPTY_REGEX = ".*?errorIfMissingOrEmpty=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_ERROR_IF_MISSING_OR_EMPTY_PATTERN = Pattern.compile(".*?errorIfMissingOrEmpty=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_MIN_DEPTH_REGEX = ".*?minDepth=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_MIN_DEPTH_PATTERN = Pattern.compile(".*?minDepth=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_MAX_DEPTH_REGEX = ".*?maxDepth=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_MAX_DEPTH_PATTERN = Pattern.compile(".*?maxDepth=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_RESOURCE_FILTER_REGEX = ".*?resourceFilter=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_RESOURCE_FILTER_PATTERN = Pattern.compile(".*?resourceFilter=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_RESOURCE_COMPARATOR_REGEX = ".*?resourceComparator=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_RESOURCE_COMPARATOR_PATTERN = Pattern.compile(".*?resourceComparator=\"(.*?)\"[^>]*+", 40);
    public static final String LABELS_TAG = " labels=\"";
    public static final String CONTEXT_TAG = " context=\"";
    public static final String CONTEXT_FILTER_TAG = " contextFilter=\"";
    public static final String XML_COMMENT_REGEX = "(?s)<!--.*?-->";
    public static final Pattern XML_COMMENT_PATTERN = Pattern.compile("(?s)<!--.*?-->", 40);
    private final Map<Integer, Integer> commentPositions = new HashMap<Integer, Integer>();

    @Override
    public boolean supports(String string) {
        return string.toLowerCase().endsWith(".xml");
    }

    @Override
    public String handle(String string) {
        String string2 = string;
        Matcher matcher = XML_COMMENT_PATTERN.matcher(string);
        while (matcher.find()) {
            this.commentPositions.put(matcher.start(), matcher.end());
        }
        matcher = XML_CHANGE_SET_PATTERN.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            Object object = this.getFirstGroupValue(string3, XML_CHANGE_SET_ID_PATTERN);
            Object object2 = this.getFirstGroupValue(string3, XML_CHANGE_SET_AUTHOR_PATTERN);
            Object object3 = this.determinePath(string2);
            String string4 = "Ignoring changeset '" + (String)object + "::" + (String)object2 + "::" + (String)object3 + "'";
            object = "Mismatched dbms for changeset '" + (String)object + "::" + (String)object2 + "::" + (String)object3 + "'";
            object2 = XML_CHANGE_SET_IGNORE_PATTERN.matcher(string3);
            object3 = XML_CHANGE_SET_DBMS_PATTERN.matcher(string3);
            if (this.isComment(matcher.start(), matcher.end(), string4) || this.isIgnored(string3, (Matcher)object2, string4) || !this.isDbmsMatch(string3, (Matcher)object3, (String)object)) continue;
            object = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? XML_LABELS_PATTERN.matcher(string3) : this.getContextMatcher(string3);
            object2 = null;
            if (((Matcher)object).find()) {
                object2 = ((Matcher)object).group(1);
            }
            int n2 = string2.length() - string.length();
            string2 = this.modifyValueInXML(string2, string3, (String)object2, matcher.start() + n2, matcher.end() + n2);
        }
        this.handleInclude(string);
        this.handleIncludes(string);
        return string2;
    }

    private boolean isComment(int n2, int n3, String string) {
        for (Map.Entry<Integer, Integer> entry : this.commentPositions.entrySet()) {
            if (n2 < entry.getKey() || n3 > entry.getValue()) continue;
            Scope.getCurrentScope().getLog(XMLChangelogRewriter.class).info(string);
            return true;
        }
        return false;
    }

    private Matcher getContextMatcher(String string) {
        if (string.contains("contextFilter")) {
            return XML_CONTEXT_FILTER_PATTERN.matcher(string);
        }
        return XML_CONTEXT_PATTERN.matcher(string);
    }

    private void handleInclude(String object) {
        object = XML_INCLUDE_PATTERN.matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            String string = ((Matcher)object).group(1);
            Object object2 = XML_INCLUDE_FILE_PATTERN.matcher(string);
            if (!((Matcher)object2).find() || (object2 = ((Matcher)object2).group(1)) == null) continue;
            Matcher matcher = XML_INCLUDE_IGNORE_PATTERN.matcher(string);
            if (this.isComment(((Matcher)object).start(), ((Matcher)object).end(), "Ignoring commented include file '" + (String)object2 + "'") || this.isIgnored(string, matcher, "Ignoring include file '" + (String)object2 + "'")) continue;
            this.handleIncludedFile((String)object2);
        }
    }

    private boolean isIgnored(String string, Matcher matcher, String string2) {
        if (!string.contains(" ignore")) {
            return false;
        }
        if (matcher.find() && Boolean.parseBoolean(matcher.group(1))) {
            Scope.getCurrentScope().getUI().sendMessage(string2);
            return true;
        }
        return false;
    }

    private boolean isDbmsMatch(String string, Matcher matcher, String string2) {
        if (!string.contains(" dbms")) {
            return true;
        }
        if (matcher.find() && !this.databaseChangelog.isDbmsMatch(string = matcher.group(1))) {
            Scope.getCurrentScope().getUI().sendMessage(string2);
            return false;
        }
        return true;
    }

    @Override
    protected void handleIncludes(String object) {
        object = XML_INCLUDE_ALL_PATTERN.matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            Object object2 = ((Matcher)object).group(1);
            String string = this.getFirstGroupValue((String)object2, XML_INCLUDE_ALL_PATH_PATTERN);
            String string2 = "Ignoring commented includeAll path '" + string + "'";
            Object object3 = XML_INCLUDE_ALL_IGNORE_PATTERN.matcher((CharSequence)object2);
            if (this.isComment(((Matcher)object).start(), ((Matcher)object).end(), string2) || this.isIgnored((String)object2, (Matcher)object3, string2)) continue;
            boolean bl2 = false;
            object3 = this.getFirstGroupValue((String)object2, XML_INCLUDE_ALL_ERROR_IF_MISSING_OR_EMPTY_PATTERN);
            if (object3 != null) {
                bl2 = Boolean.parseBoolean((String)object3);
            }
            object2 = this.findResources((String)object2, string, bl2);
            this.handleFoundResources(string, bl2, (SortedSet<Resource>)object2);
        }
    }

    private SortedSet<Resource> findResources(String string, String string2, boolean bl2) {
        String string3 = this.getFirstGroupValue(string, XML_INCLUDE_ALL_FILTER_PATTERN);
        if (string3 == null) {
            string3 = this.getFirstGroupValue(string, XML_INCLUDE_ALL_RESOURCE_FILTER_PATTERN);
        }
        string3 = this.getIncludeAllFilter(string3);
        Object object = this.getFirstGroupValue(string, XML_INCLUDE_ALL_RESOURCE_COMPARATOR_PATTERN);
        object = this.getResourceComparator((String)object);
        int n2 = 1;
        String string4 = this.getFirstGroupValue(string, XML_INCLUDE_ALL_MIN_DEPTH_PATTERN);
        if (string4 != null) {
            n2 = Integer.parseInt(string4);
        }
        int n3 = Integer.MAX_VALUE;
        String string5 = this.getFirstGroupValue(string, XML_INCLUDE_ALL_MAX_DEPTH_PATTERN);
        if (string5 != null) {
            n3 = Integer.parseInt(string5);
        }
        boolean bl3 = false;
        if ((string = this.getFirstGroupValue(string, XML_INCLUDE_ALL_RELATIVE_TO_CHANGELOG_FILE_PATTERN)) != null) {
            bl3 = Boolean.parseBoolean(string);
        }
        string = Scope.getCurrentScope().getResourceAccessor();
        return this.databaseChangelog.findResources(string2, bl3, (IncludeAllFilter)string3, bl2, (Comparator)object, (ResourceAccessor)string, n2, n3);
    }

    private String modifyValueInXML(String string, String string2, String string3, int n2, int n3) {
        String string4 = this.getFirstGroupValue(string2, XML_CHANGE_SET_ID_PATTERN);
        String string5 = this.getFirstGroupValue(string2, XML_CHANGE_SET_AUTHOR_PATTERN);
        String string6 = this.determinePath(string);
        string4 = this.databaseChangelog.getChangeSet(string6, string5, string4);
        if (string4 != null && StringUtil.isNotEmpty((String)(string4 = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? string4.getLabels().toString() : this.createContextStringForFile((ChangeSet)string4))) && (string3 == null || !string3.equals(string4))) {
            string2 = this.rewriteValueInXML(string2, string3, string4);
            string = string.substring(0, n2) + string2 + string.substring(n3);
        }
        return string;
    }

    @Override
    protected String determinePath(String string) {
        if (this.includedPath != null) {
            string = (string = this.getFirstGroupValue(string, XML_DATABASECHANGELOG_PATTERN)) != null ? string : this.includedPath;
        } else {
            XMLChangelogRewriter xMLChangelogRewriter = this;
            string = xMLChangelogRewriter.getPath(xMLChangelogRewriter.databaseChangelog);
        }
        return string;
    }

    private String rewriteValueInXML(String string, String string2, String string3) {
        string = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? (string2 == null ? string.replace(">", LABELS_TAG + string3 + "\">") : string.replace(LABELS_TAG + string2 + "\"", LABELS_TAG + string3 + "\"")) : (string2 == null ? string.replace(">", CONTEXT_TAG + string3 + "\">") : (string.contains(CONTEXT_FILTER_TAG) ? string.replace(CONTEXT_FILTER_TAG + string2 + "\"", CONTEXT_FILTER_TAG + string3 + "\"") : string.replace(CONTEXT_TAG + string2 + "\"", CONTEXT_TAG + string3 + "\"")));
        return string;
    }
}

