/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks;

import com.datical.liquibase.ext.checks.JSqlParserCache$CacheKey;
import com.datical.liquibase.ext.checks.SqlParseException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import liquibase.Scope;
import liquibase.logging.Logger;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;

@ThreadSafe
public class JSqlParserCache {
    private static final ConcurrentHashMap<JSqlParserCache$CacheKey, Statements> parsedStatementCache = new ConcurrentHashMap();

    public static Statements parseSql(String object, boolean bl2) {
        Logger logger = Scope.getCurrentScope().getLog(JSqlParserCache.class);
        JSqlParserCache$CacheKey jSqlParserCache$CacheKey = new JSqlParserCache$CacheKey((String)object, bl2);
        if (parsedStatementCache.containsKey(jSqlParserCache$CacheKey)) {
            logger.fine("Cache hit for ".concat(String.valueOf(jSqlParserCache$CacheKey)));
            return parsedStatementCache.get(jSqlParserCache$CacheKey);
        }
        logger.fine("Cache miss for ".concat(String.valueOf(jSqlParserCache$CacheKey)));
        try {
            object = CCJSqlParserUtil.parseStatements((String)object, cCJSqlParser -> cCJSqlParser.withSquareBracketQuotation(bl2));
        }
        catch (JSQLParserException jSQLParserException) {
            throw new SqlParseException(jSQLParserException.getMessage());
        }
        parsedStatementCache.put(jSqlParserCache$CacheKey, (Statements)object);
        return object;
    }
}

