/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import java.io.FileNotFoundException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.resource.Resource;

public class InMemoryChecksFileAccessor
implements FileAccessor {
    private final Map<String, String> files = new ConcurrentHashMap<String, String>();

    @Override
    public FileAccessorDTO loadFileContents(String string) {
        if (this.files.containsKey(string)) {
            FileAccessorDTO fileAccessorDTO = new FileAccessorDTO();
            new FileAccessorDTO().versioned = false;
            fileAccessorDTO.contents = this.files.get(string);
            FileAccessorDTO fileAccessorDTO2 = fileAccessorDTO;
            fileAccessorDTO2.setOriginalContents(fileAccessorDTO2.contents);
            return fileAccessorDTO;
        }
        throw new FileNotFoundException();
    }

    @Override
    public void writeFileContents(Resource resource, String string, String string2, boolean bl2) {
        if (bl2 && this.exists(string)) {
            throw new FileAlreadyExistsException(string);
        }
        this.files.put(string, string2);
    }

    public boolean exists(String string) {
        return this.files.containsKey(string);
    }
}

