/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.SqlParseException;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.ObjectTypesEnum;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public abstract class AbstractObjectNamingRule
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    private Boolean getCaseSensitiveParam(DynamicRule dynamicRule, OperatorEnum operatorEnum) {
        Boolean bl2 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (operatorEnum != OperatorEnum.REGEXP) {
            bl2 = (Boolean)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CASE_SENSITIVE);
        } else if (dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE) != null) {
            throw new Exception("Rule is using a " + (Object)((Object)OperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.");
        }
        return bl2;
    }

    private List<ObjectTypesEnum> getObjectTypesParam(DynamicRule dynamicRule) {
        return StringEnumListGetter.split((String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.OBJECT_TYPES), ObjectTypesEnum.class, true);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    private boolean doEvaluate(List<Change> object, ChangeSet changeSet, DynamicRule dynamicRule, boolean bl2) {
        OperatorEnum operatorEnum = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        String string = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        Boolean bl3 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        try {
            bl3 = this.getCaseSensitiveParam(dynamicRule, operatorEnum);
        }
        catch (Exception exception) {
            this.putResultUnsuccessful(changeSet, exception.getMessage(), dynamicRule, bl2);
        }
        List<ObjectTypesEnum> list = this.getObjectTypesParam(dynamicRule);
        object = object.iterator();
        while (object.hasNext()) {
            Change change = (Change)object.next();
            for (ObjectTypesEnum objectTypesEnum : list) {
                Object object2;
                int n2;
                Object object3;
                ArrayList arrayList = new ArrayList();
                if (change instanceof AbstractSQLChange && this.shouldParseSql()) {
                    try {
                        object3 = StringUtil.splitSQL((String)StringUtil.stripComments((String)this.getSql((AbstractSQLChange)change)), (String)((AbstractSQLChange)change).getEndDelimiter());
                        n2 = ((String[])object3).length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Statements statements = JSqlParserCache.parseSql(object3[i2], true);
                            ArrayList<String> arrayList2 = new ArrayList<String>();
                            for (Statement statement : statements.getStatements()) {
                                arrayList2.addAll((Collection<String>)objectTypesEnum.sqlCallback.apply(statement));
                            }
                            if (arrayList2.isEmpty() || !this.notAllEmpty(arrayList2)) continue;
                            arrayList.addAll(arrayList2.stream().map(AbstractObjectNamingRule::cleanseQuotes).collect(Collectors.toList()));
                        }
                    }
                    catch (SqlParseException sqlParseException) {
                        object3 = (Level)Scope.getCurrentScope().get(ChecksRunCommandStep.SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG.getName(), (Object)Level.FINE);
                        Scope.getCurrentScope().getLog(this.getClass()).log((Level)object3, "Failed to parse SQL", (Throwable)sqlParseException);
                        this.addFailureRuleIteration(changeSet, "Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration$FailureReason.SQL_PARSING, dynamicRule, bl2);
                    }
                } else if (change instanceof AbstractChange && (object2 = objectTypesEnum.abstractChangeCallback.apply((AbstractChange)change)) != null && this.notAllEmpty((List<String>)object2)) {
                    arrayList.addAll(object2);
                }
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object3 = (String)object2.next();
                    n2 = operatorEnum.matches(string, (String)object3, bl3) ? 1 : 0;
                    if (!this.operatorMatchCallback(n2 != 0)) continue;
                    this.addFailureRuleIteration(changeSet, this.getFailureMessage(objectTypesEnum, operatorEnum, string, "the indicated changeset", (String)object3), dynamicRule, bl2);
                }
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, bl2);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> list, Database database, DynamicRule dynamicRule) {
        return this.doEvaluate(list, changeSet, dynamicRule, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        OperatorEnum operatorEnum = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        String string = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        Boolean bl2 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        try {
            bl2 = this.getCaseSensitiveParam(dynamicRule, operatorEnum);
        }
        catch (Exception exception) {
            this.putResultUnsuccessful(databaseObject, exception.getMessage(), dynamicRule);
        }
        for (ObjectTypesEnum objectTypesEnum : this.getObjectTypesParam(dynamicRule)) {
            Object object = new ArrayList<String>(1);
            object.addAll(objectTypesEnum.getNamesFromDatabaseObject(databaseObject));
            object = object.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                boolean bl3 = operatorEnum.matches(string, string2, bl2);
                if (!this.operatorMatchCallback(bl3)) continue;
                this.addFailureRuleIteration(databaseObject, this.getFailureMessage(objectTypesEnum, operatorEnum, string, "this database object", string2), dynamicRule);
            }
        }
        return this.returnAtEndOfRule(databaseObject, dynamicRule);
    }

    public boolean shouldParseSql() {
        return true;
    }

    private boolean notAllEmpty(List<String> list) {
        return list.stream().noneMatch(StringUtil::isEmpty);
    }

    public abstract boolean operatorMatchCallback(boolean var1);

    public abstract String getFailureMessage(ObjectTypesEnum var1, OperatorEnum var2, String var3, String var4, String var5);

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.SEARCH_STRING, (string, list) -> {
            if (list.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst().get().getValue() == OperatorEnum.REGEXP) {
                return new RegexGetter().validate((String)string);
            }
            if (StringUtil.isEmpty((String)string)) {
                throw new IllegalArgumentException("The search string is empty or contains invalid characters.");
            }
            return Boolean.TRUE;
        }, null), new RuleParameter(DynamicRuleParameterEnum.OBJECT_TYPES), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE, null, object -> {
            object = ((DynamicRuleParameter)(object = object.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst().get())).getValue() instanceof String ? OperatorEnum.valueOf((String)((DynamicRuleParameter)object).getValue()) : ((DynamicRuleParameter)object).getValue();
            return object != OperatorEnum.REGEXP;
        }));
    }

    private static String cleanseQuotes(String string) {
        Iterator<String> iterator = Arrays.asList("\"", "[", "`");
        List<String> list = Arrays.asList("\"", "]", "`");
        String string2 = string;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string.startsWith(string3)) continue;
            string2 = string2.substring(string3.length());
            break;
        }
        for (String string3 : list) {
            if (!string.endsWith(string3)) continue;
            string2 = string2.substring(0, string2.length() - string3.length());
            break;
        }
        return string2;
    }
}

