/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.reports.ReportFormat;
import com.datical.liquibase.ext.util.HelpUtil;
import java.util.Collections;
import java.util.List;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.util.ValueHandlerUtil;

public class ReportCommandArguments
extends AbstractCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"report"};
    public static final CommandArgumentDefinition<String> REPORT_NAME;
    public static final CommandArgumentDefinition<String> REPORT_PATH;
    public static final CommandArgumentDefinition<Boolean> REPORT_ENABLED;
    public static final CommandArgumentDefinition<ReportFormat> REPORT_FORMAT;
    public static final String DEFAULT_REPORT_NAME_DATE_FORMAT = "dd-MMM-yyyy-HHmmss";
    public static final String REPORT_NAME_EXAMPLE;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(ReportArguments.class);
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        commandResultsBuilder = commandResultsBuilder.getCommandScope();
        Object object = (Boolean)commandResultsBuilder.getArgumentValue(REPORT_ENABLED);
        String string = (String)commandResultsBuilder.getArgumentValue(REPORT_NAME);
        String string2 = (String)commandResultsBuilder.getArgumentValue(REPORT_PATH);
        ReportFormat reportFormat = (ReportFormat)((Object)commandResultsBuilder.getArgumentValue(REPORT_FORMAT));
        object = this.handleArgumentHierarchy((Boolean)object, string, string2, reportFormat);
        commandResultsBuilder.provideDependency(ReportArguments.class, object);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        HelpUtil.hideCommandNameInHelpView(commandDefinition);
    }

    private ReportArguments handleArgumentHierarchy(Boolean bl2, String string, String string2, ReportFormat reportFormat) {
        Boolean bl3 = (Boolean)ReportConfiguration.ENABLED.getCurrentValue();
        String string3 = (String)ReportConfiguration.NAME.getCurrentValue();
        String string4 = (String)ReportConfiguration.PATH.getCurrentValue();
        ReportFormat reportFormat2 = (ReportFormat)((Object)ReportConfiguration.FORMAT.getCurrentValue());
        boolean bl4 = bl2 != null;
        boolean bl5 = string != null;
        boolean bl6 = string2 != null;
        boolean bl7 = reportFormat != null;
        bl2 = bl4 ? bl2 : bl3;
        string = bl5 ? string : string3;
        string2 = bl6 ? string2 : string4;
        reportFormat = bl7 ? reportFormat : reportFormat2;
        return new ReportArguments(bl2, string, string2, reportFormat, !bl5, !bl6, !bl7);
    }

    static {
        REPORT_NAME_EXAMPLE = String.format("report-%s", DEFAULT_REPORT_NAME_DATE_FORMAT);
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        REPORT_ENABLED = commandBuilder.argument("reportEnabled", Boolean.class).description("Enable or disable reporting.").hidden().build();
        REPORT_NAME = commandBuilder.argument("reportName", String.class).description("The name of the report.").hidden().build();
        REPORT_PATH = commandBuilder.argument("reportPath", String.class).description("The path to the directory to generate the report.").hidden().build();
        REPORT_FORMAT = commandBuilder.argument("reportFormat", ReportFormat.class).description("The format of the report. Currently, can only be set to \"html\".").setValueHandler(object -> (ReportFormat)ValueHandlerUtil.getEnum(ReportFormat.class, (Object)object, (String)"Report Format")).hidden().build();
    }
}

