/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class DriftConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<Boolean> ENABLED;
    public static final ConfigurationDefinition<Integer> SEVERITY;
    public static final ConfigurationDefinition<Integer> MISSING_SEVERITY;
    public static final ConfigurationDefinition<Integer> UNEXPECTED_SEVERITY;
    public static final ConfigurationDefinition<Integer> CHANGED_SEVERITY;

    private static Integer determineSeverity(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            object = (String)object;
            try {
                int n2 = Integer.parseInt((String)object);
                if (n2 < 0 || n2 > 4) {
                    throw new IllegalArgumentException(String.format("WARNING: The drift report format value '%s' is not valid. Valid values are 0-4", object));
                }
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(String.format("WARNING: The drift report format value '%s' is not valid. Valid values are 0-4", object));
            }
        }
        if (object instanceof Integer) {
            int n3 = (Integer)object;
            if (n3 < 0 || n3 > 4) {
                throw new IllegalArgumentException(String.format("WARNING: The drift report format value '%d' is not valid. Valid values are 0-4", n3));
            }
            return n3;
        }
        return null;
    }

    public static int determineSeverity(int n2) {
        if (n2 == 0) {
            n2 = (Integer)SEVERITY.getCurrentValue();
        }
        return n2;
    }

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.drift");
        ENABLED = builder.define("enabled", Boolean.class).setDescription("Enable or disable drift detection").setDefaultValue((Object)Boolean.FALSE).setHidden(true).build();
        SEVERITY = builder.define("severity", Integer.class).setDescription("Global object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
        MISSING_SEVERITY = builder.define("severity.missing", Integer.class).setDescription("Missing object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
        UNEXPECTED_SEVERITY = builder.define("severity.unexpected", Integer.class).setDescription("Unexpected object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
        CHANGED_SEVERITY = builder.define("severity.changed", Integer.class).setDescription("Changed object drift severity").setValueHandler(DriftConfiguration::determineSeverity).setDefaultValue((Object)0).setHidden(true).build();
    }
}

