/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.visitor;

import java.util.Collection;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.util.StringUtil;

public class ModifyChangeSetContextsVisitor
implements ChangeSetVisitor {
    private final String setAsContexts;
    private final boolean forceReplace;

    public ModifyChangeSetContextsVisitor(String string, boolean bl2) {
        this.setAsContexts = string;
        this.forceReplace = bl2;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database object, Set<ChangeSetFilterResult> set) {
        databaseChangeLog = new ContextExpression((Collection)changeSet.getContextFilter().getContexts());
        if (this.forceReplace) {
            if (!databaseChangeLog.toString().equalsIgnoreCase(this.setAsContexts)) {
                Scope.getCurrentScope().getLog(ModifyChangeSetContextsVisitor.class).info(String.format("Change set %s contexts set to %s", changeSet, this.setAsContexts));
            }
            changeSet.setContextFilter(new ContextExpression(this.setAsContexts));
            return;
        }
        object = StringUtil.splitAndTrim((String)this.setAsContexts, (String)",");
        object.forEach(arg_0 -> ((ContextExpression)databaseChangeLog).add(arg_0));
        if (!this.prepareContexts(databaseChangeLog.toString()).equalsIgnoreCase(changeSet.getContextFilter().toString())) {
            Scope.getCurrentScope().getLog(ModifyChangeSetContextsVisitor.class).info(String.format("Change set %s contexts set to %s", changeSet.toString(), StringUtil.join((Collection)object, (String)",")));
        }
        changeSet.setContextFilter((ContextExpression)databaseChangeLog);
    }

    private String prepareContexts(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return string;
        }
        return string.replace("(", "").replace(")", "");
    }
}

