/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowDefinition;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Distinct;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.First;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.GroupByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.KSQLWindow;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralView;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.MySqlSqlCacheFlags;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OptimizeFor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Skip;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Top;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Wait;

public class PlainSelect
extends Select {
    private Distinct distinct = null;
    private List<SelectItem<?>> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<LateralView> lateralViews;
    private List<Join> joins;
    private Expression where;
    private GroupByElement groupBy;
    private Expression having;
    private Expression qualify;
    private OptimizeFor optimizeFor;
    private Skip skip;
    private boolean mySqlHintStraightJoin;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean skipLocked;
    private Wait wait;
    private boolean mySqlSqlCalcFoundRows = false;
    private MySqlSqlCacheFlags mySqlCacheFlag = null;
    private String forXmlPath;
    private KSQLWindow ksqlWindow = null;
    private boolean noWait = false;
    private boolean emitChanges = false;
    private List<WindowDefinition> windowDefinitions;
    private boolean isUsingFinal = false;

    @Deprecated
    public boolean isUseBrackets() {
        return false;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem<?>> getSelectItems() {
        return this.selectItems;
    }

    public SelectItem<?> getSelectItem(int n2) {
        return this.selectItems.get(n2);
    }

    public Expression getWhere() {
        return this.where;
    }

    public PlainSelect withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public void setIntoTables(List<Table> list) {
        this.intoTables = list;
    }

    public PlainSelect withSelectItems(List<SelectItem<?>> list) {
        this.setSelectItems(list);
        return this;
    }

    public void setSelectItems(List<SelectItem<?>> list) {
        this.selectItems = list;
    }

    public PlainSelect addSelectItems(SelectItem<?> ... selectItemArray) {
        this.selectItems = Optional.ofNullable(this.selectItems).orElseGet(ArrayList::new);
        this.selectItems.addAll(Arrays.asList(selectItemArray));
        return this;
    }

    public PlainSelect addSelectItems(Expression ... expressionArray) {
        this.selectItems = Optional.ofNullable(this.selectItems).orElseGet(ArrayList::new);
        for (Expression expression : expressionArray) {
            this.selectItems.add(SelectItem.from(expression));
        }
        return this;
    }

    public PlainSelect addSelectItem(Expression expression, Alias alias) {
        this.selectItems = Optional.ofNullable(this.selectItems).orElseGet(ArrayList::new);
        this.selectItems.add(new SelectItem<Expression>(expression, alias));
        return this;
    }

    public PlainSelect addSelectItem(Expression expression) {
        return this.addSelectItem(expression, null);
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<LateralView> getLateralViews() {
        return this.lateralViews;
    }

    public void setLateralViews(Collection<LateralView> collection) {
        if (this.lateralViews == null && collection != null) {
            this.lateralViews = new ArrayList<LateralView>();
        } else {
            this.lateralViews.clear();
        }
        if (collection != null) {
            this.lateralViews.addAll(collection);
            return;
        }
        this.lateralViews = null;
    }

    public PlainSelect addLateralView(LateralView lateralView) {
        if (this.lateralViews == null) {
            this.lateralViews = new ArrayList<LateralView>();
        }
        this.lateralViews.add(lateralView);
        return this;
    }

    public PlainSelect withLateralViews(Collection<LateralView> collection) {
        this.setLateralViews(collection);
        return this;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public Join getJoin(int n2) {
        return this.joins.get(n2);
    }

    public PlainSelect addJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withJoins(list);
    }

    public PlainSelect withJoins(List<Join> list) {
        this.setJoins(list);
        return this;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public boolean isUsingFinal() {
        return this.isUsingFinal;
    }

    public void setUsingFinal(boolean bl2) {
        this.isUsingFinal = bl2;
    }

    public PlainSelect withUsingFinal(boolean bl2) {
        this.setUsingFinal(bl2);
        return this;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public OptimizeFor getOptimizeFor() {
        return this.optimizeFor;
    }

    public void setOptimizeFor(OptimizeFor optimizeFor) {
        this.optimizeFor = optimizeFor;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public boolean getMySqlHintStraightJoin() {
        return this.mySqlHintStraightJoin;
    }

    public void setMySqlHintStraightJoin(boolean bl2) {
        this.mySqlHintStraightJoin = bl2;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public Expression getQualify() {
        return this.qualify;
    }

    public PlainSelect setQualify(Expression expression) {
        this.qualify = expression;
        return this;
    }

    public GroupByElement getGroupBy() {
        return this.groupBy;
    }

    public void setGroupByElement(GroupByElement groupByElement) {
        this.groupBy = groupByElement;
    }

    public PlainSelect addGroupByColumnReference(Expression expression) {
        this.groupBy = Optional.ofNullable(this.groupBy).orElseGet(GroupByElement::new);
        this.groupBy.addGroupByExpression(expression);
        return this;
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.oracleHierarchical = oracleHierarchicalExpression;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean bl2) {
        this.forUpdate = bl2;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table table) {
        this.forUpdateTable = table;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void setWait(Wait wait) {
        this.wait = wait;
    }

    public Wait getWait() {
        return this.wait;
    }

    public String getForXmlPath() {
        return this.forXmlPath;
    }

    public void setForXmlPath(String string) {
        this.forXmlPath = string;
    }

    public KSQLWindow getKsqlWindow() {
        return this.ksqlWindow;
    }

    public void setKsqlWindow(KSQLWindow kSQLWindow) {
        this.ksqlWindow = kSQLWindow;
    }

    public void setEmitChanges(boolean bl2) {
        this.emitChanges = bl2;
    }

    public boolean isEmitChanges() {
        return this.emitChanges;
    }

    public List<WindowDefinition> getWindowDefinitions() {
        return this.windowDefinitions;
    }

    public void setWindowDefinitions(List<WindowDefinition> list) {
        this.windowDefinitions = list;
    }

    public boolean isSkipLocked() {
        return this.skipLocked;
    }

    public void setSkipLocked(boolean bl2) {
        this.skipLocked = bl2;
    }

    @Override
    public StringBuilder appendSelectBodyTo(StringBuilder stringBuilder) {
        stringBuilder.append("SELECT ");
        if (this.mySqlHintStraightJoin) {
            stringBuilder.append("STRAIGHT_JOIN ");
        }
        if (this.oracleHint != null) {
            stringBuilder.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            stringBuilder.append(this.skip).append(" ");
        }
        if (this.first != null) {
            stringBuilder.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            stringBuilder.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            stringBuilder.append(this.top).append(" ");
        }
        if (this.mySqlCacheFlag != null) {
            stringBuilder.append(this.mySqlCacheFlag.name()).append(" ");
        }
        if (this.mySqlSqlCalcFoundRows) {
            stringBuilder.append("SQL_CALC_FOUND_ROWS ");
        }
        stringBuilder.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            stringBuilder.append(" INTO ");
            Iterator<Serializable> iterator = this.intoTables.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        if (this.fromItem != null) {
            stringBuilder.append(" FROM ").append(this.fromItem);
            if (this.lateralViews != null) {
                for (LateralView serializable : this.lateralViews) {
                    stringBuilder.append(" ").append(serializable);
                }
            }
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        stringBuilder.append(", ").append(join);
                        continue;
                    }
                    stringBuilder.append(" ").append(join);
                }
            }
            if (this.isUsingFinal) {
                stringBuilder.append(" FINAL");
            }
            if (this.ksqlWindow != null) {
                stringBuilder.append(" WINDOW ").append(this.ksqlWindow);
            }
            if (this.where != null) {
                stringBuilder.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                stringBuilder.append(this.oracleHierarchical);
            }
            if (this.groupBy != null) {
                stringBuilder.append(" ").append(this.groupBy);
            }
            if (this.having != null) {
                stringBuilder.append(" HAVING ").append(this.having);
            }
            if (this.qualify != null) {
                stringBuilder.append(" QUALIFY ").append(this.qualify);
            }
            if (this.windowDefinitions != null) {
                stringBuilder.append(" WINDOW ");
                stringBuilder.append(this.windowDefinitions.stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
            }
            if (this.emitChanges) {
                stringBuilder.append(" EMIT CHANGES");
            }
            if (this.isForUpdate()) {
                stringBuilder.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    stringBuilder.append(" OF ").append(this.forUpdateTable);
                }
                if (this.wait != null) {
                    stringBuilder.append(this.wait);
                }
                if (this.isNoWait()) {
                    stringBuilder.append(" NOWAIT");
                } else if (this.isSkipLocked()) {
                    stringBuilder.append(" SKIP LOCKED");
                }
            }
        } else if (this.where != null) {
            stringBuilder.append(" WHERE ").append(this.where);
        }
        return stringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        super.appendTo(stringBuilder);
        if (this.optimizeFor != null) {
            stringBuilder.append(this.optimizeFor);
        }
        if (this.forXmlPath != null) {
            stringBuilder.append(" FOR XML PATH(").append(this.forXmlPath).append(")");
        }
        return stringBuilder.toString();
    }

    public PlainSelect withMySqlSqlCalcFoundRows(boolean bl2) {
        this.setMySqlSqlCalcFoundRows(bl2);
        return this;
    }

    public PlainSelect withMySqlSqlNoCache(MySqlSqlCacheFlags mySqlSqlCacheFlags) {
        this.setMySqlSqlCacheFlag(mySqlSqlCacheFlags);
        return this;
    }

    public void setMySqlSqlCalcFoundRows(boolean bl2) {
        this.mySqlSqlCalcFoundRows = bl2;
    }

    public void setMySqlSqlCacheFlag(MySqlSqlCacheFlags mySqlSqlCacheFlags) {
        this.mySqlCacheFlag = mySqlSqlCacheFlags;
    }

    public boolean getMySqlSqlCalcFoundRows() {
        return this.mySqlSqlCalcFoundRows;
    }

    public MySqlSqlCacheFlags getMySqlSqlCacheFlag() {
        return this.mySqlCacheFlag;
    }

    public void setNoWait(boolean bl2) {
        this.noWait = bl2;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public PlainSelect withDistinct(Distinct distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public PlainSelect withIntoTables(List<Table> list) {
        this.setIntoTables(list);
        return this;
    }

    public PlainSelect withWhere(Expression expression) {
        this.setWhere(expression);
        return this;
    }

    public PlainSelect withOptimizeFor(OptimizeFor optimizeFor) {
        this.setOptimizeFor(optimizeFor);
        return this;
    }

    public PlainSelect withSkip(Skip skip) {
        this.setSkip(skip);
        return this;
    }

    public PlainSelect withMySqlHintStraightJoin(boolean bl2) {
        this.setMySqlHintStraightJoin(bl2);
        return this;
    }

    public PlainSelect withFirst(First first) {
        this.setFirst(first);
        return this;
    }

    public PlainSelect withTop(Top top) {
        this.setTop(top);
        return this;
    }

    public PlainSelect withOracleHierarchical(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.setOracleHierarchical(oracleHierarchicalExpression);
        return this;
    }

    public PlainSelect withOracleHint(OracleHint oracleHint) {
        this.setOracleHint(oracleHint);
        return this;
    }

    @Override
    public PlainSelect withOracleSiblings(boolean bl2) {
        this.setOracleSiblings(bl2);
        return this;
    }

    public PlainSelect withForUpdate(boolean bl2) {
        this.setForUpdate(bl2);
        return this;
    }

    public PlainSelect withForUpdateTable(Table table) {
        this.setForUpdateTable(table);
        return this;
    }

    public PlainSelect withForXmlPath(String string) {
        this.setForXmlPath(string);
        return this;
    }

    public PlainSelect withKsqlWindow(KSQLWindow kSQLWindow) {
        this.setKsqlWindow(kSQLWindow);
        return this;
    }

    public PlainSelect withNoWait(boolean bl2) {
        this.setNoWait(bl2);
        return this;
    }

    public PlainSelect withSkipLocked(boolean bl2) {
        this.setSkipLocked(bl2);
        return this;
    }

    public PlainSelect withHaving(Expression expression) {
        this.setHaving(expression);
        return this;
    }

    public PlainSelect withWait(Wait wait) {
        this.setWait(wait);
        return this;
    }

    public PlainSelect addSelectItems(Collection<? extends SelectItem<?>> collection) {
        List list = Optional.ofNullable(this.getSelectItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSelectItems(list);
    }

    public PlainSelect addIntoTables(Table ... tableArray) {
        List list = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        Collections.addAll(list, tableArray);
        return this.withIntoTables(list);
    }

    public PlainSelect addIntoTables(Collection<? extends Table> collection) {
        List list = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withIntoTables(list);
    }

    public PlainSelect addJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withJoins(list);
    }

    public <E extends FromItem> E getFromItem(Class<E> clazz) {
        return (E)((FromItem)clazz.cast(this.getFromItem()));
    }

    public <E extends Expression> E getWhere(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhere()));
    }

    public <E extends Expression> E getHaving(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getHaving()));
    }
}

