/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.CreateView;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.ForceOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.TemporaryOption;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class CreateViewValidator
extends AbstractValidator<CreateView> {
    @Override
    public void validate(CreateView createView) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.createView);
            this.validateFeature(validationCapability, createView.isOrReplace(), Feature.createOrReplaceView);
            this.validateFeature(validationCapability, !ForceOption.NONE.equals((Object)createView.getForce()), Feature.createViewForce);
            this.validateFeature(validationCapability, !TemporaryOption.NONE.equals((Object)createView.getTemporary()), Feature.createViewTemporary);
            this.validateFeature(validationCapability, createView.isMaterialized(), Feature.createViewMaterialized);
            this.validateName(validationCapability, NamedObject.view, createView.getView().getFullyQualifiedName(), false, new NamedObject[0]);
        }
        SelectValidator selectValidator = this.getValidator(SelectValidator.class);
        createView.getSelect().accept(selectValidator);
    }
}

