/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalExpressions(upsert.getExpressions());
        this.validateOptionalSelect(upsert.getSelect());
        this.validateDuplicate(upsert);
    }

    private void validateOptionalSelect(Select select) {
        if (select != null) {
            SelectValidator selectValidator = this.getValidator(SelectValidator.class);
            select.accept(selectValidator);
        }
    }

    private void validateDuplicate(Upsert object) {
        if (((Upsert)object).getDuplicateUpdateSets() != null) {
            for (UpdateSet updateSet : ((Upsert)object).getDuplicateUpdateSets()) {
                this.validateOptionalExpressions(updateSet.getColumns());
                this.validateOptionalExpressions(updateSet.getValues());
            }
        }
    }
}

