/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changeset;

import com.datical.liquibase.ext.changeset.ProChangeSet;
import com.datical.liquibase.ext.changeset.ProModifyChangeSets;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.ModifyChangeSets;
import liquibase.changeset.StandardChangeSetService;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;

public class ProChangeSetService
extends StandardChangeSetService {
    private boolean warningIssued;

    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return 101;
        }
        return -1;
    }

    public ChangeSet createChangeSet(DatabaseChangeLog changeLog) {
        return new ProChangeSet(changeLog);
    }

    public ChangeSet createChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextFilter, String dbmsList, DatabaseChangeLog databaseChangeLog) {
        return new ProChangeSet(id, author, alwaysRun, runOnChange, filePath, contextFilter, dbmsList, null, null, true, ObjectQuotingStrategy.LEGACY, databaseChangeLog);
    }

    public ChangeSet createChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextFilter, String dbmsList, String runWith, String runWithSpoolFile, boolean runInTransaction, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        return new ProChangeSet(id, author, alwaysRun, runOnChange, DatabaseChangeLog.normalizePath((String)filePath), contextFilter, dbmsList, runWith, runWithSpoolFile, runInTransaction, databaseChangeLog.getObjectQuotingStrategy(), databaseChangeLog);
    }

    public ModifyChangeSets createModifyChangeSets(ParsedNode node) throws ParsedNodeException {
        return new ProModifyChangeSets(node);
    }

    public void modifyChangeSets(ChangeSet changeSet, ModifyChangeSets modifyChangeSets) {
        if (changeSet == null) {
            return;
        }
        super.modifyChangeSets(changeSet, modifyChangeSets);
        changeSet.getChanges().stream().filter(AbstractSQLChange.class::isInstance).forEach(change -> {
            String endDelimiter = this.handleGlobalEndDelimiter(((AbstractSQLChange)change).getEndDelimiter());
            if (endDelimiter == null) {
                endDelimiter = ProChangeSetService.determineEndDelimiter((ProModifyChangeSets)modifyChangeSets, (AbstractSQLChange)change);
            }
            ((AbstractSQLChange)change).setEndDelimiter(endDelimiter);
        });
    }

    public String getEndDelimiter(ChangeSet changeSet) {
        if (changeSet == null) {
            return (String)LiquibaseProConfiguration.GLOBAL_END_DELIMITER.getCurrentValue();
        }
        return ((ProChangeSet)changeSet).getEndDelimiter();
    }

    public String getOverrideDelimiter(String endDelimiter) {
        return this.handleGlobalEndDelimiter(endDelimiter);
    }

    private String handleGlobalEndDelimiter(String endDelimiter) {
        if (Boolean.TRUE.equals(LiquibaseProConfiguration.GLOBAL_END_DELIMITER_PRIORITIZED.getCurrentValue()) && (endDelimiter = (String)LiquibaseProConfiguration.GLOBAL_END_DELIMITER.getCurrentValue()) == null && !this.warningIssued) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("The '--pro-global-end-delimiter-prioritization' property is set to use the global end delimiter to override local end delimiter setting, but no global end delimiter is set. No prioritization action occurred.");
            this.warningIssued = true;
        }
        return endDelimiter;
    }

    private static String determineEndDelimiter(ProModifyChangeSets modifyChangeSets, AbstractSQLChange change) {
        String endDelimiter = change.getEndDelimiter();
        if (endDelimiter == null) {
            endDelimiter = modifyChangeSets.getEndDelimiter();
        }
        return endDelimiter;
    }
}

