/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SqlNotAllowedToContainSelectAll
extends AbstractNotAllowedToContainRule {
    @Override
    public List<Pattern> getReservedPhrase() {
        return Collections.singletonList(Pattern.compile("select\\s*\\*"));
    }

    @Override
    public String getName() {
        return "Warn on Detection of 'SELECT *'";
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that Changesets which include 'SELECT *' are reviewed carefully to ensure that selecting all fields in a query is necessary and won\u2019t lead to unacceptable resource utilization which can degrade performance of the database.";
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public String getDescription() {
        return "This check warns a user when generated or raw SQL contains 'SELECT *' statements so that they can ensure  selecting all fields from a table in a query is safe and necessary";
    }

    @Override
    public String getShortName() {
        return "SqlSelectStarWarn";
    }

    @Override
    public int getPriority() {
        return 55;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }
}

