/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksBulksetCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "bulkSet"};
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<Boolean> CHECKS_DISABLE_ARG;
    public static final CommandArgumentDefinition<Boolean> CHECKS_ENABLE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SEVERITY_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        boolean force = commandScope.getConfiguredValue(FORCE_ARG).getProvidedValue().getValue() != null;
        boolean enable = commandScope.getConfiguredValue(CHECKS_ENABLE_ARG).getProvidedValue().getValue() != null;
        boolean disable = commandScope.getConfiguredValue(CHECKS_DISABLE_ARG).getProvidedValue().getValue() != null;
        String severityValue = (String)commandScope.getConfiguredValue(CHECKS_SEVERITY_ARG).getValue();
        boolean[] blArray = new boolean[3];
        blArray[0] = enable;
        blArray[1] = disable;
        boolean bl = blArray[2] = severityValue != null;
        if (this.moreThanOne(blArray)) {
            throw new IllegalArgumentException("Specify only one of enable, disable, and severity arguments");
        }
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksBulksetCommandStep.checkFileArgExistence(checksSettingsFile, "checks settings");
        String autoUpdate = (String)commandScope.getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate);
        List<AbstractLiquibaseRule> instances = ChecksBulksetCommandStep.listAllRules();
        CheckSettingsConfig config = helper.read(instances);
        this.throwExceptionIfPackageFile(config);
        if (config == null) {
            return;
        }
        SeverityEnum severityEnum = null;
        if (severityValue != null && (severityEnum = this.determineSeverityEnum(severityValue)) == null) {
            throw new IllegalArgumentException("Invalid severity argument '" + severityValue + ";");
        }
        if (!force) {
            String promptMessage;
            if (enable) {
                promptMessage = "IMPORTANT: Are you sure you want to enable all checks? (Y/N)";
            } else if (disable) {
                promptMessage = "IMPORTANT: Are you sure you want to disable all checks? (Y/N)";
            } else {
                if (severityEnum == null) {
                    throw new IllegalArgumentException("Invalid severity argument '" + severityValue + ";");
                }
                promptMessage = "IMPORTANT: Are you sure you want to set all the checks to severity <'" + severityValue + "'> (" + severityEnum.getExitValue() + ")>? (Y/N):";
            }
            String should = (String)Scope.getCurrentScope().getUI().prompt(promptMessage, (Object)"N", (input, type) -> {
                if (input == null || !input.equalsIgnoreCase("y") && !input.equalsIgnoreCase("n") && !input.equalsIgnoreCase("yes") && !input.equalsIgnoreCase("no")) {
                    throw new IllegalArgumentException();
                }
                return input;
            }, String.class);
            char c = should.toLowerCase().charAt(0);
            if (c == 'n') {
                String message = "No checks configuration changes were made";
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe(message);
                Scope.getCurrentScope().getUI().sendMessage(message);
                return;
            }
        }
        AtomicBoolean modified = new AtomicBoolean();
        SeverityEnum finalSeverityEnum = severityEnum;
        config.getRules().forEach(r -> {
            boolean b;
            if (finalSeverityEnum == null && r instanceof DynamicRule && !(b = ((DynamicRule)r).getParameters().stream().allMatch(p -> p.getValue() != null))) {
                return;
            }
            modified.set(true);
            if (enable) {
                r.setEnabled(true);
            } else if (disable) {
                r.setEnabled(false);
            } else if (finalSeverityEnum != null) {
                r.setSeverity(finalSeverityEnum);
            }
        });
        if (!modified.get()) {
            String message = "No checks were modified";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe(message);
            Scope.getCurrentScope().getUI().sendMessage(message);
            return;
        }
        helper.write(config);
        if (enable) {
            Scope.getCurrentScope().getUI().sendMessage("\n\nAll qualifying checks have been enabled\n");
        } else if (disable) {
            Scope.getCurrentScope().getUI().sendMessage("\n\nAll qualifying checks have been disabled\n");
        } else if (severityEnum != null) {
            Scope.getCurrentScope().getUI().sendMessage("\n\nAll qualifying checks have been set to severity '" + severityEnum.name() + "'.\n");
        }
        ChecksShowCommandStep.writeTableToOutput(resultsBuilder, config, false);
        config.outputWarningMessage();
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Set the properties of all qualifying checks with one command"));
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private SeverityEnum determineSeverityEnum(String severityValue) {
        SeverityEnum severityEnum = ChecksBulksetCommandStep.convertToExitCode(severityValue);
        if (severityEnum == null) {
            severityEnum = ChecksBulksetCommandStep.convertToSeverityEnum(severityValue);
        }
        return severityEnum;
    }

    private static String createExitCodeOptionsString() {
        SeverityEnum[] enums = SeverityEnum.values();
        List<SeverityEnum> list = Arrays.asList(enums);
        Collections.reverse(list);
        StringBuilder builder = new StringBuilder();
        list.forEach(e -> {
            if (builder.length() > 0) {
                builder.append(", '").append(e.getExitValue()).append("'");
            } else {
                builder.append("'").append(e.getExitValue()).append("'");
            }
        });
        return builder.toString();
    }

    private static String createSeverityEnumOptionsString() {
        SeverityEnum[] enums = SeverityEnum.values();
        List<SeverityEnum> list = Arrays.asList(enums);
        Collections.reverse(list);
        StringBuilder builder = new StringBuilder();
        list.forEach(e -> {
            if (builder.length() > 0) {
                builder.append(", '").append(e.name()).append("'");
            } else {
                builder.append("'").append(e.name()).append("'");
            }
        });
        return builder.toString();
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static SeverityEnum convertToExitCode(String severityValue) {
        int exitCode;
        try {
            exitCode = Integer.parseInt(severityValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        SeverityEnum[] enums = SeverityEnum.values();
        int finalExitCode = exitCode;
        List matches = Arrays.stream(enums).filter(e -> finalExitCode == e.getExitValue()).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        return (SeverityEnum)((Object)matches.get(0));
    }

    private static SeverityEnum convertToSeverityEnum(String severityValue) {
        SeverityEnum[] enums = SeverityEnum.values();
        List matches = Arrays.stream(enums).filter(e -> severityValue.equalsIgnoreCase(e.name())).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        return (SeverityEnum)((Object)matches.get(0));
    }

    private boolean moreThanOne(boolean ... params) {
        int count = 0;
        for (boolean b : params) {
            count += b ? 1 : 0;
        }
        return count > 1;
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_DISABLE_ARG = builder.argument("disable", Boolean.class).description("Disable all qualifying checks in the checks settings file").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            if (input instanceof Boolean) {
                return (Boolean)input;
            }
            String disableInput = (String)input;
            if (disableInput.equalsIgnoreCase("true")) {
                return Boolean.valueOf(disableInput);
            }
            String messageString = "\nWARNING:  The input '" + disableInput + "' is not valid.  Options: 'true'.";
            throw new IllegalArgumentException(messageString);
        }).build();
        CHECKS_ENABLE_ARG = builder.argument("enable", Boolean.class).description("Enable all qualifying checks in the checks settings file").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            if (input instanceof Boolean) {
                return (Boolean)input;
            }
            String enableInput = (String)input;
            if (enableInput.equalsIgnoreCase("true")) {
                return Boolean.valueOf(enableInput);
            }
            String messageString = "\nWARNING:  The input '" + enableInput + "' is not valid.  Options: 'true'.";
            throw new IllegalArgumentException(messageString);
        }).build();
        CHECKS_SEVERITY_ARG = builder.argument("severity", String.class).description("Set the severity of all checks to the value specified").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String severityValue = (String)input;
            if (ChecksBulksetCommandStep.convertToExitCode(severityValue) == null && ChecksBulksetCommandStep.convertToSeverityEnum(severityValue) == null) {
                String messageString = ChecksBulksetCommandStep.isInteger(severityValue) ? "\nWARNING:  Severity value '" + severityValue + "' is not valid.  Options: " + ChecksBulksetCommandStep.createExitCodeOptionsString() : "\nWARNING:  Severity value '" + severityValue + "' is not valid.  Options: " + ChecksBulksetCommandStep.createSeverityEnumOptionsString();
                throw new IllegalArgumentException(messageString);
            }
            return severityValue;
        }).build();
        FORCE_ARG = builder.argument("force", Boolean.class).description("Do not ask for confirmation when running this command").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            if (input instanceof Boolean) {
                return (Boolean)input;
            }
            String forceInput = (String)input;
            if (forceInput.equalsIgnoreCase("true")) {
                return Boolean.valueOf(forceInput);
            }
            String messageString = "\nWARNING:  The input '" + forceInput + "' is not valid. Options: 'true'.";
            throw new IllegalArgumentException(messageString);
        }).build();
        CHECKS_AUTO_UPDATE_ARG = builder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String autoUpdateArg = (String)input;
            if (autoUpdateArg.equalsIgnoreCase("on") || autoUpdateArg.equalsIgnoreCase("off")) {
                return autoUpdateArg;
            }
            String messageString = "\nWARNING:  The autoUpdate value '" + autoUpdateArg + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException(messageString);
        }).build();
    }
}

