/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.drift;

import com.datical.liquibase.ext.reports.drift.ReportObjectContainer;
import java.util.Date;
import java.util.List;
import liquibase.database.jvm.JdbcConnection;

public class DriftReportParameters {
    private final String reportName;
    private final Date date;
    private final String targetUrl;
    private final String sourceUrl;
    private final String createdByUser;
    private final String hostName;
    private final List<ReportObjectContainer> missing;
    private final List<ReportObjectContainer> unexpected;
    private final List<ReportObjectContainer> changed;
    private final String jsonMissing;
    private final String jsonUnexpected;
    private final String jsonChanged;
    private final String numberMissing;
    private final String numberUnexpected;
    private final String numberChanged;
    private final boolean showMissing;
    private final boolean showUnexpected;
    private final boolean showChanged;
    private final boolean hasMissing;
    private final boolean hasUnexpected;
    private final boolean hasChanged;
    private final String path;
    private final String commandArgs;
    private final String reportMode;
    private final String reportNameParameterName;
    private final String reportPathParameterName;
    private final String reportFormatParameterName;
    private final String visibleTargetUrl;
    private final String visibleSourceUrl;
    private final int missingSeverity;
    private final int unexpectedSeverity;
    private final int changedSeverity;
    private final String unifiedSqlDiff;
    private final boolean foundDrift;
    private final String liquibaseVersion;
    private final String targetPlatformVersion;
    private final String referencePlatformVersion;
    private final String schemas;
    private final String diffTypes;
    private final String excludeObjects;
    private final String includeObjects;

    public DriftReportParameters(boolean foundDrift, String reportName, String targetUrl, String sourceUrl, String visibleTargetUrl, String visibleSourceUrl, String createdByUser, String hostName, List<ReportObjectContainer> missing, List<ReportObjectContainer> unexpected, List<ReportObjectContainer> changed, String jsonMissing, String jsonUnexpected, String jsonChanged, String numberMissing, String numberUnexpected, String numberChanged, boolean showMissing, boolean showUnexpected, boolean showChanged, boolean hasMissing, boolean hasUnexpected, boolean hasChanged, String path, String commandArgs, String reportMode, String reportNameParameterName, String reportPathParameterName, String reportFormatParameterName, int missingSeverity, int unexpectedSeverity, int changedSeverity, String unifiedSqlDiff, String liquibaseVersion, String targetPlatformVersion, String referencePlatformVersion, String schemas, String diffTypes, String excludeObjects, String includeObjects) {
        this.foundDrift = foundDrift;
        this.reportName = reportName;
        this.reportMode = reportMode;
        this.reportNameParameterName = reportNameParameterName;
        this.reportPathParameterName = reportPathParameterName;
        this.reportFormatParameterName = reportFormatParameterName;
        this.missingSeverity = missingSeverity;
        this.unexpectedSeverity = unexpectedSeverity;
        this.changedSeverity = changedSeverity;
        this.date = new Date();
        this.targetUrl = targetUrl;
        this.sourceUrl = sourceUrl;
        this.createdByUser = createdByUser;
        this.hostName = hostName;
        this.missing = missing;
        this.unexpected = unexpected;
        this.changed = changed;
        this.jsonMissing = jsonMissing;
        this.jsonUnexpected = jsonUnexpected;
        this.jsonChanged = jsonChanged;
        this.numberMissing = numberMissing;
        this.numberUnexpected = numberUnexpected;
        this.numberChanged = numberChanged;
        this.showMissing = showMissing;
        this.showUnexpected = showUnexpected;
        this.showChanged = showChanged;
        this.hasMissing = hasMissing;
        this.hasUnexpected = hasUnexpected;
        this.hasChanged = hasChanged;
        this.commandArgs = commandArgs;
        this.path = path;
        this.unifiedSqlDiff = unifiedSqlDiff;
        this.visibleTargetUrl = visibleTargetUrl;
        this.visibleSourceUrl = visibleSourceUrl;
        this.liquibaseVersion = liquibaseVersion;
        this.targetPlatformVersion = targetPlatformVersion;
        this.referencePlatformVersion = referencePlatformVersion;
        this.schemas = schemas;
        this.diffTypes = diffTypes;
        this.excludeObjects = excludeObjects;
        this.includeObjects = includeObjects;
    }

    public boolean getShowMissing() {
        return this.showMissing;
    }

    public boolean getShowUnexpected() {
        return this.showUnexpected;
    }

    public boolean getShowChanged() {
        return this.showChanged;
    }

    public boolean getHasMissing() {
        return this.hasMissing;
    }

    public boolean getHasUnexpected() {
        return this.hasUnexpected;
    }

    public boolean getHasChanged() {
        return this.hasChanged;
    }

    public boolean getFoundDrift() {
        return this.foundDrift;
    }

    public String getTargetUrl() {
        return JdbcConnection.sanitizeUrl((String)this.targetUrl);
    }

    public String getSourceUrl() {
        return JdbcConnection.sanitizeUrl((String)this.sourceUrl);
    }

    public String getPath() {
        if (this.path != null) {
            if (this.path.equals(".")) {
                return "./";
            }
        } else {
            return "";
        }
        return this.path;
    }

    public String getReportName() {
        return this.reportName;
    }

    public Date getDate() {
        return this.date;
    }

    public String getCreatedByUser() {
        return this.createdByUser;
    }

    public String getHostName() {
        return this.hostName;
    }

    public List<ReportObjectContainer> getMissing() {
        return this.missing;
    }

    public List<ReportObjectContainer> getUnexpected() {
        return this.unexpected;
    }

    public List<ReportObjectContainer> getChanged() {
        return this.changed;
    }

    public String getJsonMissing() {
        return this.jsonMissing;
    }

    public String getJsonUnexpected() {
        return this.jsonUnexpected;
    }

    public String getJsonChanged() {
        return this.jsonChanged;
    }

    public String getNumberMissing() {
        return this.numberMissing;
    }

    public String getNumberUnexpected() {
        return this.numberUnexpected;
    }

    public String getNumberChanged() {
        return this.numberChanged;
    }

    public String getCommandArgs() {
        return this.commandArgs;
    }

    public String getReportMode() {
        return this.reportMode;
    }

    public String getReportNameParameterName() {
        return this.reportNameParameterName;
    }

    public String getReportPathParameterName() {
        return this.reportPathParameterName;
    }

    public String getReportFormatParameterName() {
        return this.reportFormatParameterName;
    }

    public String getVisibleTargetUrl() {
        return this.visibleTargetUrl;
    }

    public String getVisibleSourceUrl() {
        return this.visibleSourceUrl;
    }

    public int getMissingSeverity() {
        return this.missingSeverity;
    }

    public int getUnexpectedSeverity() {
        return this.unexpectedSeverity;
    }

    public int getChangedSeverity() {
        return this.changedSeverity;
    }

    public String getUnifiedSqlDiff() {
        return this.unifiedSqlDiff;
    }

    public String getLiquibaseVersion() {
        return this.liquibaseVersion;
    }

    public String getTargetPlatformVersion() {
        return this.targetPlatformVersion;
    }

    public String getReferencePlatformVersion() {
        return this.referencePlatformVersion;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public String getDiffTypes() {
        return this.diffTypes;
    }

    public String getExcludeObjects() {
        return this.excludeObjects;
    }

    public String getIncludeObjects() {
        return this.includeObjects;
    }
}

