/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.util.StringUtil;

public class LiquibaseRuleResult {
    private final List<RuleIteration> executions = new ArrayList<RuleIteration>();
    private final AbstractLiquibaseRule rule;
    private final AbstractConfigurableRule configuredRule;

    public LiquibaseRuleResult(AbstractLiquibaseRule rule) {
        this.rule = rule;
        this.configuredRule = null;
    }

    public LiquibaseRuleResult(AbstractLiquibaseRule rule, AbstractConfigurableRule configuredRule, RuleIteration ... executions) {
        this.rule = rule;
        this.configuredRule = configuredRule;
        this.executions.addAll(Arrays.asList(executions));
    }

    public List<RuleIteration> getExecutions() {
        return this.executions;
    }

    public AbstractLiquibaseRule getRule() {
        return this.rule;
    }

    public AbstractConfigurableRule getConfigurableRule() {
        return this.configuredRule;
    }

    public boolean hasRuleSucceeded() {
        for (RuleIteration execution : this.executions) {
            if (execution.isSuccess()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSqlParseFailures() {
        return this.executions.stream().anyMatch(rr -> RuleIteration.FailureReason.SQL_PARSING.equals((Object)rr.getFailureReason()));
    }

    public boolean hasInvalidChangelogFileTypeFailures() {
        return this.executions.stream().anyMatch(rr -> RuleIteration.FailureReason.INVALID_CHANGELOG_FILE_TYPE.equals((Object)rr.getFailureReason()));
    }

    public String getRuleShortName() {
        return this.getRuleShortName(true);
    }

    public String getRuleShortName(boolean surroundWithParens) {
        String shortName = this.configuredRule != null && StringUtil.isNotEmpty((String)this.configuredRule.getShortName()) ? this.configuredRule.getShortName() : this.getRule().getShortName();
        if (surroundWithParens && StringUtil.isNotEmpty((String)shortName)) {
            shortName = " (" + shortName + ")";
        }
        return shortName;
    }

    public SeverityEnum getRuleSeverity(Integer sqlParserFailSeverity) {
        SeverityEnum severityEnum = sqlParserFailSeverity != null && this.hasSqlParseFailures() ? SeverityEnum.fromExitValue(sqlParserFailSeverity) : (this.configuredRule != null ? this.configuredRule.getSeverity() : this.getRule().getSeverity());
        return severityEnum;
    }

    public int getRuleExitValue(Integer sqlParserFailSeverity) {
        int exitValue = this.getRuleSeverity(sqlParserFailSeverity).getExitValue();
        return exitValue;
    }
}

