/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.util.StringUtil;

public class RuleIteration {
    private boolean success;
    private boolean isRollback = false;
    private FailureReason failureReason;
    private final List<String> messages = new ArrayList<String>();

    public RuleIteration(boolean success) {
        this(success, (String[])null);
    }

    public RuleIteration(boolean success, boolean isRollback) {
        this(success, isRollback, (String[])null);
    }

    public RuleIteration(boolean success, String ... messages) {
        this.success = success;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public RuleIteration(boolean success, boolean isRollback, String ... messages) {
        this.success = success;
        this.isRollback = isRollback;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public RuleIteration(FailureReason failureReason) {
        this(failureReason, (String[])null);
    }

    public RuleIteration(FailureReason failureReason, String ... messages) {
        this(failureReason, false, messages);
    }

    public RuleIteration(FailureReason failureReason, boolean isRollback, String ... messages) {
        this.success = false;
        this.failureReason = failureReason;
        this.isRollback = isRollback;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public boolean addMessage(String message) {
        return this.messages.add(message);
    }

    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    public String buildDisplayMessage() {
        return StringUtil.join(this.getMessages(), (String)";");
    }

    public static enum FailureReason {
        SQL_PARSING,
        INVALID_CHANGELOG_FILE_TYPE;

    }
}

