/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintStatement;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import liquibase.ChecksumVersion;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="addCheckConstraint", description="Adds a check constrant to an existing column or set of columns.", priority=1, appliesTo={"column"})
public class AddCheckConstraintChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String constraintName;
    private String constraintBody;
    private Boolean disabled;
    private Boolean validate;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.catalog", since="3.0", description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema", description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table to create the check constraint on")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="Name of the check constraint to add")
    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @DatabaseChangeProperty(description="Specifies whether the check constraint is disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE, description="The SQL creating the check constraint. constraintBody is not supported in the XML format; however, you can specify the constraint SQL inline within the addCheckConstraint definition.")
    public String getConstraintBody() {
        return this.constraintBody;
    }

    public void setConstraintBody(String functionBody) {
        this.constraintBody = functionBody;
    }

    @DatabaseChangeProperty(description="Set to true if the constraint has ENABLE VALIDATE set, or false if the constraint has ENABLE NOVALIDATE set.")
    public Boolean getValidate() {
        return this.validate;
    }

    public void setValidate(Boolean validate) {
        this.validate = validate;
    }

    public SqlStatement[] generateStatements(Database database) {
        boolean disabled = false;
        if (this.getDisabled() != null) {
            disabled = this.getDisabled();
        }
        AddCheckConstraintStatement statement = new AddCheckConstraintStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getConstraintName());
        statement.setConstraintBody(this.getConstraintBody());
        statement.setDisabled(disabled);
        statement.setValidate(this.validate);
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return "Check constraint added to " + this.getTableName();
    }

    protected Change[] createInverses() {
        DropCheckConstraintChange inverse = new DropCheckConstraintChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public void finishInitialization() {
        Boolean originValidateValue = this.validate;
        if (originValidateValue != null) {
            return;
        }
        ChangeSet changeSet = this.getChangeSet();
        if (changeSet == null) {
            return;
        }
        CheckSum checkSumStored = changeSet.getStoredCheckSum();
        if (checkSumStored == null) {
            return;
        }
        this.addValidChecksumForValidateAttIfNeeded(changeSet, true);
        this.addValidChecksumForValidateAttIfNeeded(changeSet, null);
    }

    private void addValidChecksumForValidateAttIfNeeded(ChangeSet changeSet, Boolean validate) {
        ChecksumVersion currentChecksumVersion = changeSet.getStoredCheckSum() != null ? ChecksumVersion.enumFromChecksumVersion((int)changeSet.getStoredCheckSum().getVersion()) : ChecksumVersion.latest();
        changeSet.clearCheckSum();
        this.validate = validate;
        CheckSum checkSumForThisIfValidateTrue = changeSet.generateCheckSum(currentChecksumVersion);
        if (changeSet.getStoredCheckSum().equals((Object)checkSumForThisIfValidateTrue)) {
            this.getChangeSet().addValidCheckSum(checkSumForThisIfValidateTrue.toString());
        }
    }

    public String[] getExcludedFieldFilters(ChecksumVersion version) {
        if (version.lowerOrEqualThan(ChecksumVersion.V8)) {
            return new String[0];
        }
        return new String[]{"constraintBody", "disabled", "validate"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckSum generateCheckSum() {
        ChecksumVersion version = Scope.getCurrentScope().getChecksumVersion();
        if (version.lowerOrEqualThan(ChecksumVersion.V8)) {
            return super.generateCheckSum();
        }
        InputStream stream = null;
        try {
            String constraintBody = this.constraintBody;
            Charset encoding = (Charset)GlobalConfiguration.FILE_ENCODING.getCurrentValue();
            if (constraintBody != null) {
                stream = new ByteArrayInputStream(constraintBody.getBytes(encoding));
            }
            CheckSum checkSum = CheckSum.compute((InputStream)new AbstractSQLChange.NormalizingStream(stream), (boolean)false);
            CheckSum checkSum2 = CheckSum.compute((String)(super.generateCheckSum().toString() + ":" + checkSum.toString()));
            return checkSum2;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

