/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.mysql;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.FunctionSnapshotGenerator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringUtil;

public class MySQLFunctionSnapshotGenerator
extends FunctionSnapshotGenerator {
    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> rs = this.castToListOfMaps(queryForList);
        StringBuilder body = new StringBuilder();
        StringBuilder paramsString = new StringBuilder();
        String name = null;
        Boolean valid = null;
        for (Map<String, ?> row : rs) {
            if (name == null) {
                name = (String)row.get("Function");
            }
            if (body.length() != 0) continue;
            String objectBody = (String)row.get("Create Function");
            if (objectBody != null) {
                objectBody = objectBody.replaceAll("CREATE DEFINER=(.*) FUNCTION ", "CREATE FUNCTION ");
            } else {
                objectBody = " [CANNOT READ OBJECT BODY]";
                String warningMessage = null;
                if (database instanceof MariaDBDatabase) {
                    warningMessage = "\nThe current MariaDB user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. Learn more about altering permissions with suggested MariaDB GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mariadbgrants.html\n";
                } else if (database instanceof MySQLDatabase) {
                    warningMessage = "\nThe current MySQL user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. This is potentially due to a known\n MySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering permissions with suggested MySQL GRANTs at\nhttps://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                }
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + warningMessage);
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(warningMessage);
            }
            body.append(objectBody.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        body = new StringBuilder(StringUtil.trimToEmpty((String)StringUtil.trimToEmpty((String)body.toString().replace("\r\n", "\n").replace("\r", "\n"))));
        StoredDatabaseLogic storedDatabaseLogic = ((Function)((Function)((Function)this.createReturnObject().setSchema(storedDatabaseLogicExample.getSchema())).setName(name)).setValid(valid)).setBody(body.toString());
        return storedDatabaseLogic;
    }
}

