/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.storedproc.MissingStoredProcedureChangeGenerator;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

@LiquibaseService
public class MissingStoredProcedureExternalFileChangeGenerator
extends MissingStoredProcedureChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && StoredProcedure.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixMissing(databaseObject, diffOutputControl, database, database2, changeGeneratorChain);
        CreateProcedureChange change = MissingStoredProcedureExternalFileChangeGenerator.findChange(CreateProcedureChange.class, changes);
        change.setRelativeToChangelogFile(Boolean.valueOf(true));
        change.setPath(ObjectSqlFileUtil.writeObjectSql((StoredDatabaseLogic)((StoredProcedure)databaseObject)));
        change.setProcedureText(null);
        return changes;
    }
}

