/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.RenameTriggerStatement;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class RenameTriggerGenerator
extends AbstractSqlGenerator<RenameTriggerStatement> {
    public boolean supports(RenameTriggerStatement renameTriggertStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(RenameTriggerStatement renameTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (database instanceof CockroachDatabase) {
            return validationErrors;
        }
        validationErrors.checkRequiredField("oldTriggerName", (Object)renameTriggerStatement.getOldTriggerName());
        validationErrors.checkRequiredField("newTriggerName", (Object)renameTriggerStatement.getNewTriggerName());
        validationErrors.checkDisallowedField("catalogName", (Object)renameTriggerStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        if (database instanceof PostgresDatabase) {
            validationErrors.checkRequiredField("tableName", (Object)renameTriggerStatement.getTableName());
        }
        return validationErrors;
    }

    public Sql[] generateSql(RenameTriggerStatement renameTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (database instanceof OracleDatabase) {
            return new Sql[]{new UnparsedSql("ALTER TRIGGER " + database.escapeObjectName(renameTriggerStatement.getCatalogName(), renameTriggerStatement.getSchemaName(), renameTriggerStatement.getOldTriggerName(), Trigger.class) + " RENAME TO " + database.escapeObjectName(renameTriggerStatement.getNewTriggerName(), Trigger.class), new DatabaseObject[0])};
        }
        if (database instanceof PostgresDatabase) {
            return new Sql[]{new UnparsedSql("ALTER TRIGGER " + database.escapeObjectName(renameTriggerStatement.getOldTriggerName(), Trigger.class) + " ON " + database.escapeObjectName(null, renameTriggerStatement.getSchemaName(), renameTriggerStatement.getTableName(), Trigger.class) + " RENAME TO " + database.escapeObjectName(renameTriggerStatement.getNewTriggerName(), Trigger.class), new DatabaseObject[0])};
        }
        String schemaName = renameTriggerStatement.getSchemaName();
        Sql[] returnSql = null;
        returnSql = schemaName != null && !schemaName.isEmpty() ? new Sql[]{new UnparsedSql("sp_rename '" + database.escapeObjectName(schemaName, Schema.class) + "." + renameTriggerStatement.getOldTriggerName() + "', '" + renameTriggerStatement.getNewTriggerName() + "'", new DatabaseObject[0])} : new Sql[]{new UnparsedSql("sp_rename '" + renameTriggerStatement.getOldTriggerName() + "', '" + renameTriggerStatement.getNewTriggerName() + "'", new DatabaseObject[0])};
        ArrayList<Sql> sqlList = new ArrayList<Sql>(Arrays.asList(returnSql));
        return sqlList.toArray(new Sql[0]);
    }
}

