/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import java.util.Arrays;
import liquibase.util.StringUtil;

public class EnumValueHandler {
    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, Object input, String parameterName) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String stringInput = (String)input;
            if (Arrays.stream(enumClass.getEnumConstants()).noneMatch(enumValue -> enumValue.toString().equalsIgnoreCase(stringInput))) {
                throw new IllegalArgumentException(String.format("WARNING: The %s value '%s' is not valid. Valid values include: '%s'", parameterName.toLowerCase(), stringInput, StringUtil.join((Object[])enumClass.getEnumConstants(), (String)"', '", Object::toString)));
            }
            return Enum.valueOf(enumClass, stringInput.toUpperCase());
        }
        if (enumClass.isAssignableFrom(input.getClass())) {
            return (T)((Enum)enumClass.cast(input));
        }
        return null;
    }
}

