/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ParseException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;

final class ParseCapability
implements ValidationCapability {
    public static final String NAME = "parsing";
    private String statements;
    private Statements parsedStatement;

    public ParseCapability(String statements) {
        this.statements = statements;
    }

    public String getStatements() {
        return this.statements;
    }

    public Statements getParsedStatements() {
        return this.parsedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ValidationContext context, Consumer<ValidationException> errorConsumer) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            this.parsedStatement = CCJSqlParserUtil.parseStatements(CCJSqlParserUtil.newParser(this.statements).withConfiguration(context.getConfiguration()), executorService);
        }
        catch (JSQLParserException e) {
            errorConsumer.accept(new ParseException("Cannot parse statement: " + e.getMessage(), e));
        }
        finally {
            executorService.shutdown();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

