/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class CheckForSpecificPatternsInSQL
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, database, false);
    }

    private boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, Database database, boolean isRollback) {
        DynamicRuleParameter searchStringParam = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        DynamicRuleParameter stripCommentsParam = dynamicRule.getParameter(DynamicRuleParameterEnum.STRIP_COMMENTS);
        Objects.requireNonNull(searchStringParam);
        Objects.requireNonNull(messageParam);
        Objects.requireNonNull(stripCommentsParam);
        Pattern searchString = Pattern.compile((String)searchStringParam.getValue());
        String messageTemplate = (String)messageParam.getValue();
        Boolean stripComments = (Boolean)stripCommentsParam.getValue();
        for (Change change : changes) {
            try {
                if (!this.doCheck(change, database, searchString, stripComments)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(messageTemplate, searchString, changeSet), dynamicRule, isRollback);
            }
            catch (IllegalStateException ise) {
                Scope.getCurrentScope().getLog(CheckForSpecificPatternsInSQL.class).info("Error generating SQL for change '" + change.getDescription() + "': " + ise.getMessage());
                this.addFailureRuleIteration(changeSet, "Unable to generate SQL for change '" + change.getDescription() + "'. Checks executed against the H2 database for this object type are not available.", (AbstractConfigurableRule)dynamicRule);
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr, database, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    private boolean doCheck(Change change, Database database, Pattern searchString, boolean stripComments) throws IllegalStateException {
        String sql = change instanceof AbstractSQLChange ? this.getSql((AbstractSQLChange)change) : this.generateSqlFromChange(change, database);
        if (stripComments) {
            sql = StringUtil.stripComments((String)sql);
        }
        if (StringUtil.isEmpty((String)sql)) {
            return false;
        }
        return searchString.matcher(sql).find();
    }

    private String getFailureMessage(String messageTemplate, Pattern searchString, ChangeSet changeSet) {
        return messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", searchString.pattern()).replace("<CHANGESET>", changeSet.getId());
    }

    @Override
    public String getDescription() {
        return "This check scans SQL for the presence of specific patterns and warns the user when they are found.";
    }

    @Override
    public String getShortName() {
        return "SqlUserDefinedPatternCheck";
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.MESSAGE), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS));
    }
}

