/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public abstract class AbstractLiquibaseDynamicRule
extends AbstractLiquibaseRule {
    private Map<String, String> generatedSqlCache = new HashMap<String, String>();

    @Override
    public final boolean evaluate(Facts facts) throws Exception {
        List<ChangeSet> changeSets = this.getChangeSetFromFacts(facts);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = this.getSnapshotFromFacts(facts);
        Database database = this.getDatabaseFromFacts(facts);
        if (changeSets == null && lazyDatabaseSnapshot == null) {
            return this.putResultSuccessful((ChangeSet)null, false, null);
        }
        DynamicRule dr = (DynamicRule)this.getAbstractConfigurableRuleFromFacts(facts);
        if (!this.validateParameters(dr)) {
            return this.putResultUnsuccessful((ChangeSet)null, "Validation failed on the parameters for this rule.", (AbstractConfigurableRule)dr);
        }
        boolean result = false;
        if (changeSets != null) {
            for (ChangeSet changeSet : changeSets) {
                if (!this.shouldBeEvaluated(changeSet, (AbstractConfigurableRule)dr)) continue;
                boolean thisResult = (Boolean)Scope.child(Collections.singletonMap("changeset", changeSet), () -> this.internalEvaluate(changeSet, database, dr));
                if (!result) {
                    result = thisResult;
                }
                if (!Boolean.TRUE.equals(this.getShouldCheckRollbackFromFacts(facts))) continue;
                Scope.child(Collections.singletonMap("changeset", changeSet), () -> this.internalRollbackEvaluate(changeSet, changeSet.getRollback().getChanges(), database, dr));
            }
        }
        if (lazyDatabaseSnapshot != null) {
            try {
                DiffResult diffResult = lazyDatabaseSnapshot.createDiffResult();
                Database snapshotDatabase = lazyDatabaseSnapshot.getDatabase();
                for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
                    if (snapshotDatabase.isLiquibaseObject(databaseObject) || !this.shouldBeEvaluated(databaseObject, (AbstractConfigurableRule)dr)) continue;
                    boolean thisResult = this.internalEvaluate(databaseObject, dr);
                    if (result) continue;
                    result = thisResult;
                }
            }
            catch (CommandExecutionException | DatabaseException | InvalidExampleException e) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to generate diff from database snapshot, and thus failed to run the database checks.", e);
                this.putResultUnsuccessful((DatabaseObject)null, "Failed to generate diff from database snapshot", (AbstractConfigurableRule)dr);
            }
        }
        return result;
    }

    public String generateSqlFromChange(Change change, Database database) throws IllegalStateException {
        SqlStatement[] statements;
        String key = this.generateKey(change);
        if (this.generatedSqlCache.containsKey(key)) {
            return this.generatedSqlCache.get(key);
        }
        StringBuilder builder = new StringBuilder();
        for (SqlStatement statement : statements = change.generateStatements(database)) {
            Sql[] sqls;
            for (Sql oneSql : sqls = SqlGeneratorFactory.getInstance().generateSql(statement, database)) {
                builder.append(oneSql.toSql());
                builder.append("\n");
            }
        }
        this.generatedSqlCache.put(key, builder.toString());
        return builder.toString();
    }

    private String generateKey(Change change) {
        return change.generateCheckSum().toString();
    }

    private boolean validateParameters(DynamicRule dynamicRule) {
        List<DynamicRuleParameter> parameters = dynamicRule.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            String message = String.format("Rule instance %s has no value parameters.  No check performed", dynamicRule.getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return false;
        }
        if ((long)parameters.size() < this.getParameters().stream().filter(p -> p.getShouldPrompt() == null).count()) {
            String message = String.format("Rule instance %s has some missing value parameters.  No check performed.%nRun checks customize to supply values for the missing parameters.", dynamicRule.getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return false;
        }
        return true;
    }

    public abstract boolean internalEvaluate(ChangeSet var1, DynamicRule var2);

    public abstract boolean internalEvaluate(DatabaseObject var1, DynamicRule var2);

    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.internalEvaluate(changeSet, dynamicRule);
    }

    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return false;
    }
}

