/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.FunctionSnapshotGenerator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringUtil;

public class SnowflakeFunctionSnapshotGenerator
extends FunctionSnapshotGenerator {
    @Override
    protected StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> rs = this.castToListOfMaps(queryForList);
        StringBuilder body = new StringBuilder();
        String name = null;
        for (Map<String, ?> row : rs) {
            if (name == null) {
                name = (String)row.get("OBJECT_NAME");
            }
            String arguments = this.parseArguments((String)row.get("OBJECT_ARG"));
            String objectBody = this.getBody(storedDatabaseLogicExample, arguments, database);
            body.append(objectBody.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        body = new StringBuilder(StringUtil.trimToEmpty((String)body.toString().replace("\r\n", "\n").replace("\r", "\n")));
        StoredDatabaseLogic storedDatabaseLogic = ((Function)((Function)this.createReturnObject().setSchema(storedDatabaseLogicExample.getSchema())).setName(name)).setBody(body.toString());
        return storedDatabaseLogic;
    }

    private String getBody(StoredDatabaseLogic<?> storedDatabaseLogicExample, String arguments, Database database) throws DatabaseException {
        String sql = " SELECT GET_DDL('function', '" + storedDatabaseLogicExample.getName() + arguments + "')";
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        return (String)executor.queryForObject((SqlStatement)new RawSqlStatement(sql), String.class);
    }

    private String parseArguments(String argument) {
        return argument.replaceAll("\\w+\\s", "");
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> example, Database database) throws DatabaseException {
        return "SELECT FUNCTION_SCHEMA AS OBJECT_SCHEMA, FUNCTION_NAME AS OBJECT_NAME, ARGUMENT_SIGNATURE as OBJECT_ARG FROM information_schema.functions where FUNCTION_SCHEMA='" + example.getSchema().getName() + "' AND FUNCTION_CATALOG='" + example.getSchema().getCatalogName() + "' AND FUNCTION_NAME='" + example.getName() + "'";
    }
}

