/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license.pro;

import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.x500.X500Principal;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.license.LicenseInfo;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.Location;
import liquibase.license.pro.Base64Source;
import liquibase.license.pro.LicenseTier;
import liquibase.license.pro.LicensingSchema;
import liquibase.logging.Logger;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.LicenseValidationException;

public class DaticalTrueLicenseService
implements LicenseService {
    private static final String INVALID_LICENSE_KEY_WARN = "WARNING! Invalid license key detected: Licensed Liquibase features disabled! Get a free trial license key at https://liquibase.com/trial and include liquibase.licenseKey in defaults file, or add via CLI or Environment variable. Learn more at https://docs.liquibase.com.";
    private static final String EXPIRED_LICENSE_KEY_WARN = "WARNING! Your Liquibase License has expired! Licensed Liquibase features will be disabled! Get a free trial license key at https://liquibase.com/trial";
    private static final String RENEW_MSG = "To renew " + LicenseTier.PRO.getSubject() + " or " + LicenseTier.LABS.getSubject() + " please contact sales@liquibase.com or go to https://www.liquibase.com/pricing";
    private static final String LIQUIBASE_LICENSED_MESSAGE = "%s %s by Liquibase licensed to %s until %s";
    private static final String LIQUIBASE_OPEN_SOURCE_MSG = "Liquibase Open Source %s by Liquibase";
    private Map<String, LicenseConsumerManager> managers = new HashMap<String, LicenseConsumerManager>();
    private static AtomicBoolean hasLoggedLicenseFailure = new AtomicBoolean(false);
    private LicenseInstallResult installResult;
    private String buildVersion;
    private final List<LicenseTier> installedLicenses = new ArrayList<LicenseTier>(LicenseTier.values().length);
    private String knownInvalidLicense;
    private boolean knownExpiredLicense = false;

    public DaticalTrueLicenseService() {
        this.addManager(LicenseTier.PRO.getSubject());
        this.addManager(LicenseTier.LABS.getSubject());
        this.buildVersion = LiquibaseUtil.getBuildVersionInfo();
    }

    private void addManager(String subject) {
        LicenseConsumerManager manager = LicensingSchema.manager(subject);
        this.managers.put(subject, manager);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean licenseIsValid(String subject) {
        if (subject.equals(this.knownInvalidLicense)) {
            return false;
        }
        if (!this.licenseIsInstalled()) {
            return false;
        }
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        LicenseTier licenseTier = LicenseTier.fromSubject(subject);
        if (licenseTier == null) {
            log.severe(String.format("Unrecognized license subject: %s", subject));
            return false;
        }
        try {
            LicenseConsumerManager manager = this.managers.get(subject);
            if (manager == null) {
                log.severe("Could not create LicenseConsumerManager");
                return false;
            }
            manager.verify();
            return true;
        }
        catch (LicenseManagementException e) {
            if (licenseTier.getSupersetLicenses() != null) {
                for (LicenseTier supersetLicense : licenseTier.getSupersetLicenses()) {
                    if (!this.licenseIsValid(supersetLicense.getSubject())) continue;
                    return true;
                }
            }
            if (!hasLoggedLicenseFailure.getAndSet(true)) {
                String messageString = String.format("License with subject '%s' is not valid. %s", subject, e.getMessage());
                Scope.getCurrentScope().getLog(this.getClass()).severe(messageString, (Throwable)e);
                this.knownInvalidLicense = subject;
            }
            return false;
        }
    }

    public String getLicenseInfo() {
        String issuedTo = "";
        StringBuilder licenseSummary = new StringBuilder();
        if (!this.licenseIsInstalled()) {
            if (!this.licenseIsValid(LicenseTier.PRO.getSubject())) {
                if (this.knownExpiredLicense) {
                    licenseSummary.append(EXPIRED_LICENSE_KEY_WARN).append(StreamUtil.getLineSeparator()).append(RENEW_MSG).append(StreamUtil.getLineSeparator());
                } else if (this.installResult != null && this.installResult.messages != null && this.installResult.messages.size() > 0) {
                    licenseSummary.append(StringUtil.join((Collection)this.installResult.messages, (String)StreamUtil.getLineSeparator())).append(StreamUtil.getLineSeparator());
                }
            }
            licenseSummary.append(String.format(LIQUIBASE_OPEN_SOURCE_MSG, this.buildVersion));
        } else {
            if (this.knownExpiredLicense) {
                licenseSummary.append(EXPIRED_LICENSE_KEY_WARN).append(StreamUtil.getLineSeparator()).append(RENEW_MSG).append(StreamUtil.getLineSeparator());
                return licenseSummary.toString();
            }
            LicenseConsumerManager manager = this.getRelevantManager();
            if (manager != null) {
                try {
                    License license = manager.view();
                    X500Principal holder = license.getHolder();
                    issuedTo = DaticalTrueLicenseService.getValByAttributeTypeFromIssuerDN(holder.getName(), "CN");
                    Date expirationDate = license.getNotAfter();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                    int daysTillExpiration = this.daysTilExpiration();
                    if (this.licenseIsAboutToExpire() && daysTillExpiration > 0) {
                        licenseSummary.append(String.format(LIQUIBASE_LICENSED_MESSAGE, license.getSubject(), this.buildVersion, issuedTo, dateFormat.format(expirationDate))).append(StreamUtil.getLineSeparator()).append(String.format("WARNING!  Your license will expire in %d days!", daysTillExpiration)).append(StreamUtil.getLineSeparator()).append(RENEW_MSG);
                    } else {
                        licenseSummary.append(String.format(LIQUIBASE_LICENSED_MESSAGE, license.getSubject(), this.buildVersion, issuedTo, dateFormat.format(expirationDate)));
                    }
                }
                catch (LicenseManagementException licenseManagementException) {
                    // empty catch block
                }
            }
        }
        return licenseSummary.toString();
    }

    public LicenseInfo getLicenseInfoObject() {
        LicenseConsumerManager manager;
        if (this.licenseIsInstalled() && (manager = this.getRelevantManager()) != null) {
            try {
                License license = manager.view();
                X500Principal holder = license.getHolder();
                String issuedTo = DaticalTrueLicenseService.getValByAttributeTypeFromIssuerDN(holder.getName(), "CN");
                Date expirationDate = license.getNotAfter();
                return new LicenseInfo(issuedTo, expirationDate);
            }
            catch (LicenseManagementException licenseManagementException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean licenseIsInstalled() {
        boolean anyInstalled;
        block8: {
            if (this.installedLicenses.isEmpty()) {
                ConfiguredValue<String> configuredLicense = LiquibaseLabsConfiguration.getLicenseKey();
                if (configuredLicense == null || !configuredLicense.found()) {
                    return false;
                }
                this.installResult = this.installLicense(new Location(configuredLicense.getProvidedValue().describe(), (String)configuredLicense.getValue()));
            }
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            anyInstalled = false;
            LicenseConsumerManager manager = this.getRelevantManager();
            if (manager != null) {
                try {
                    if (this.knownExpiredLicense) {
                        return false;
                    }
                    manager.verify();
                    anyInstalled = true;
                }
                catch (LicenseValidationException lve) {
                    if (lve.getMessage().contains("License validity period has expired")) {
                        this.knownExpiredLicense = true;
                    }
                    log.severe(lve.getMessage(), (Throwable)lve);
                    anyInstalled = true;
                }
                catch (LicenseManagementException lme) {
                    if (hasLoggedLicenseFailure.getAndSet(true)) break block8;
                    LicenseTier licenseTier = this.getRelevantLicenseTier();
                    log.severe(String.format("License with subject '%s' is not valid. %s", licenseTier == null ? null : licenseTier.getSubject(), lme.getMessage()), (Throwable)lme);
                }
            }
        }
        return anyInstalled;
    }

    public void disable() {
        this.installedLicenses.clear();
    }

    public void reset() {
        this.installedLicenses.clear();
    }

    public LicenseInstallResult installLicense(final Location ... locations) {
        final LicenseInstallResult result = new LicenseInstallResult(0);
        HashMap<String, Boolean> scopedValues = new HashMap<String, Boolean>();
        scopedValues.put(GlobalConfiguration.FILTER_LOG_MESSAGES.getKey(), false);
        try {
            Scope.child(scopedValues, (Scope.ScopedRunner)new Scope.ScopedRunner(){

                public void run() {
                    for (Location location : locations) {
                        result.add(DaticalTrueLicenseService.this.installFromBase64String(location));
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean licenseIsAboutToExpire() {
        boolean anyAboutToExpire = false;
        LicenseConsumerManager manager = this.getRelevantManager();
        if (manager != null) {
            try {
                License license = manager.view();
                Date thirtyDaysFromNow = DaticalTrueLicenseService.addDays(new Date(), 30);
                Date expirationDate = license.getNotAfter();
                boolean thisOneAboutToExpire = expirationDate.before(thirtyDaysFromNow);
                anyAboutToExpire = anyAboutToExpire || thisOneAboutToExpire;
            }
            catch (LicenseManagementException licenseManagementException) {
                // empty catch block
            }
        }
        return anyAboutToExpire;
    }

    public int daysTilExpiration() {
        int smallestDifference = Integer.MAX_VALUE;
        LicenseConsumerManager manager = this.getRelevantManager();
        if (manager != null) {
            try {
                License license = manager.view();
                int diff = DaticalTrueLicenseService.daysDifference(license.getNotAfter());
                if (diff < smallestDifference) {
                    smallestDifference = diff;
                }
            }
            catch (LicenseManagementException licenseManagementException) {
                // empty catch block
            }
        }
        return smallestDifference;
    }

    public Date getExpirationDate() {
        LicenseConsumerManager manager = this.getRelevantManager();
        if (manager != null) {
            try {
                License license = manager.view();
                return license.getNotAfter();
            }
            catch (LicenseManagementException licenseManagementException) {
                // empty catch block
            }
        }
        return null;
    }

    private LicenseConsumerManager getRelevantManager() {
        LicenseTier highestValueLicenseTier = this.getRelevantLicenseTier();
        if (highestValueLicenseTier != null) {
            return this.managers.get(highestValueLicenseTier.getSubject());
        }
        return null;
    }

    private LicenseTier getRelevantLicenseTier() {
        return this.installedLicenses.stream().max(Comparator.comparingInt(LicenseTier::getValue)).orElse(null);
    }

    private LicenseInstallResult installFromBase64String(Location location) {
        int exitCode = 0;
        StringBuilder retVal = new StringBuilder();
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        for (String subject : this.managers.keySet()) {
            try {
                LicenseConsumerManager manager = this.managers.get(subject);
                manager.install(new Base64Source(location.getValue()));
                License installedLicense = manager.view();
                if (!installedLicense.getSubject().equals(subject) && this.anotherManagerCanProcess(this.managers, installedLicense)) {
                    manager.uninstall();
                    continue;
                }
                if (this.knownInvalidLicense != null) continue;
                log.info("Successfully installed license from " + location + ".\n");
                this.installedLicenses.add(LicenseTier.fromSubject(subject));
            }
            catch (LicenseValidationException lve) {
                exitCode = 1;
                if (lve.getMessage().contains("License validity period has expired")) {
                    retVal.append("WARNING! Your Liquibase License has expired! Licensed Liquibase features will be disabled! Get a free trial license key at https://liquibase.com/trial\n");
                    retVal.append(RENEW_MSG);
                    log.severe(lve.getMessage(), (Throwable)lve);
                    break;
                }
                retVal.append(INVALID_LICENSE_KEY_WARN);
                log.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + lve.getMessage() + "\n", (Throwable)lve);
                break;
            }
            catch (Exception ex) {
                exitCode = 1;
                retVal.append(INVALID_LICENSE_KEY_WARN);
                log.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + ex.getMessage() + "\n", (Throwable)ex);
                break;
            }
        }
        return new LicenseInstallResult(exitCode, retVal.toString());
    }

    private boolean anotherManagerCanProcess(Map<String, LicenseConsumerManager> managers, License installedLicense) {
        return managers.entrySet().stream().anyMatch(m -> ((String)m.getKey()).equals(installedLicense.getSubject()));
    }

    private static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    private static int daysDifference(Date date) {
        LocalDate now = LocalDate.now();
        LocalDate futureDate = LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(date.getTime()));
        return (int)ChronoUnit.DAYS.between(now, futureDate);
    }

    private static String getValByAttributeTypeFromIssuerDN(String dn, String attributeType) {
        String[] dnSplits;
        for (String dnSplit : dnSplits = dn.split(",")) {
            String[] cnSplits;
            if (!dnSplit.contains(attributeType) || (cnSplits = dnSplit.trim().split("="))[1] == null) continue;
            return cnSplits[1].trim();
        }
        return "";
    }
}

