/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.insert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.OutputClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.ReturningClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertConflictAction;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertConflictTarget;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertModifierPriority;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;

public class Insert
implements Statement {
    private Table table;
    private OracleHint oracleHint = null;
    private ExpressionList<Column> columns;
    private Select select;
    private List<UpdateSet> duplicateUpdateSets = null;
    private InsertModifierPriority modifierPriority = null;
    private boolean modifierIgnore = false;
    private ReturningClause returningClause;
    private List<UpdateSet> setUpdateSets = null;
    private List<WithItem> withItemsList;
    private OutputClause outputClause;
    private InsertConflictTarget conflictTarget;
    private InsertConflictAction conflictAction;

    public List<UpdateSet> getDuplicateUpdateSets() {
        return this.duplicateUpdateSets;
    }

    public List<UpdateSet> getSetUpdateSets() {
        return this.setUpdateSets;
    }

    public Insert withDuplicateUpdateSets(List<UpdateSet> duplicateUpdateSets) {
        this.duplicateUpdateSets = duplicateUpdateSets;
        return this;
    }

    public Insert withSetUpdateSets(List<UpdateSet> setUpdateSets) {
        this.setUpdateSets = setUpdateSets;
        return this;
    }

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> list) {
        this.columns = list;
    }

    @Deprecated
    public boolean isUseValues() {
        return this.select != null && this.select instanceof Values;
    }

    public ReturningClause getReturningClause() {
        return this.returningClause;
    }

    public Insert setReturningClause(ReturningClause returningClause) {
        this.returningClause = returningClause;
        return this;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Values getValues() {
        return this.select.getValues();
    }

    public PlainSelect getPlainSelect() {
        return this.select.getPlainSelect();
    }

    public SetOperationList getSetOperationList() {
        return this.select.getSetOperationList();
    }

    @Deprecated
    public boolean isUseSelectBrackets() {
        return false;
    }

    @Deprecated
    public boolean isUseDuplicate() {
        return this.duplicateUpdateSets != null && !this.duplicateUpdateSets.isEmpty();
    }

    public InsertModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(InsertModifierPriority modifierPriority) {
        this.modifierPriority = modifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean modifierIgnore) {
        this.modifierIgnore = modifierIgnore;
    }

    @Deprecated
    public boolean isUseSet() {
        return this.setUpdateSets != null && !this.setUpdateSets.isEmpty();
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public InsertConflictTarget getConflictTarget() {
        return this.conflictTarget;
    }

    public void setConflictTarget(InsertConflictTarget conflictTarget) {
        this.conflictTarget = conflictTarget;
    }

    public Insert withConflictTarget(InsertConflictTarget conflictTarget) {
        this.setConflictTarget(conflictTarget);
        return this;
    }

    public InsertConflictAction getConflictAction() {
        return this.conflictAction;
    }

    public void setConflictAction(InsertConflictAction conflictAction) {
        this.conflictAction = conflictAction;
    }

    public Insert withConflictAction(InsertConflictAction conflictAction) {
        this.setConflictAction(conflictAction);
        return this;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            sql.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                sql.append(withItem);
                if (iter.hasNext()) {
                    sql.append(",");
                }
                sql.append(" ");
            }
        }
        sql.append("INSERT ");
        if (this.modifierPriority != null) {
            sql.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            sql.append("IGNORE ");
        }
        sql.append("INTO ");
        sql.append(this.table).append(" ");
        if (this.columns != null) {
            sql.append("(");
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(((Column)this.columns.get(i)).getColumnName());
            }
            sql.append(") ");
        }
        if (this.outputClause != null) {
            sql.append(this.outputClause);
        }
        if (this.select != null) {
            sql.append(this.select);
        }
        if (this.setUpdateSets != null && !this.setUpdateSets.isEmpty()) {
            sql.append("SET ");
            sql = UpdateSet.appendUpdateSetsTo(sql, this.setUpdateSets);
        }
        if (this.duplicateUpdateSets != null && !this.duplicateUpdateSets.isEmpty()) {
            sql.append(" ON DUPLICATE KEY UPDATE ");
            sql = UpdateSet.appendUpdateSetsTo(sql, this.duplicateUpdateSets);
        }
        if (this.conflictAction != null) {
            sql.append(" ON CONFLICT");
            if (this.conflictTarget != null) {
                this.conflictTarget.appendTo(sql);
            }
            this.conflictAction.appendTo(sql);
        }
        if (this.returningClause != null) {
            this.returningClause.appendTo(sql);
        }
        return sql.toString();
    }

    public Insert withWithItemsList(List<WithItem> withList) {
        this.withItemsList = withList;
        return this;
    }

    public Insert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Insert withModifierPriority(InsertModifierPriority modifierPriority) {
        this.setModifierPriority(modifierPriority);
        return this;
    }

    public Insert withModifierIgnore(boolean modifierIgnore) {
        this.setModifierIgnore(modifierIgnore);
        return this;
    }

    public Insert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Insert withColumns(ExpressionList<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Insert addColumns(Column ... columns) {
        return this.addColumns(Arrays.asList(columns));
    }

    public Insert addColumns(Collection<Column> columns) {
        ExpressionList collection = Optional.ofNullable(this.getColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        collection.addAll(columns);
        return this.withColumns(collection);
    }
}

