/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util;

import java.util.LinkedList;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralSubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public class AddAliasesVisitor
implements SelectVisitor,
SelectItemVisitor {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private List<String> aliases = new LinkedList<String>();
    private boolean firstRun = true;
    private int counter = 0;
    private String prefix = "A";

    @Override
    public void visit(ParenthesedSelect parenthesedSelect) {
        parenthesedSelect.getSelect().accept(this);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        this.firstRun = true;
        this.counter = 0;
        this.aliases.clear();
        for (SelectItem<?> item : plainSelect.getSelectItems()) {
            item.accept(this);
        }
        this.firstRun = false;
        for (SelectItem<?> item : plainSelect.getSelectItems()) {
            item.accept(this);
        }
    }

    @Override
    public void visit(SetOperationList setOpList) {
        for (Select select : setOpList.getSelects()) {
            select.accept(this);
        }
    }

    @Override
    public void visit(SelectItem selectExpressionItem) {
        block2: {
            String alias;
            block1: {
                if (!this.firstRun) break block1;
                if (selectExpressionItem.getAlias() == null) break block2;
                this.aliases.add(selectExpressionItem.getAlias().getName().toUpperCase());
                break block2;
            }
            if (selectExpressionItem.getAlias() != null) break block2;
            while (this.aliases.contains(alias = this.getNextAlias().toUpperCase())) {
            }
            this.aliases.add(alias);
            selectExpressionItem.setAlias(new Alias(alias));
        }
    }

    protected String getNextAlias() {
        ++this.counter;
        return this.prefix + this.counter;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void visit(WithItem withItem) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(Values aThis) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        lateralSubSelect.getSelect().accept(this);
    }
}

