/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.visitor;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.statement.InsertDatabaseChangeLogHistoryStatement;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.statement.SqlStatement;

public class DatabaseChangelogHistoryChangeExecListener
implements ChangeExecListener,
ChangeLogSyncListener {
    private static AtomicBoolean PRINTED_UNSUPPORTED_DATABASE_MESSAGE = new AtomicBoolean(false);
    private AtomicBoolean CREATED_TABLE = new AtomicBoolean(false);

    public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
    }

    public void ran(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.ExecType execType) {
        this.logEvent(changeSet, database, "success", null);
    }

    public void willRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
    }

    public void rolledBack(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        this.logEvent(changeSet, database, "success", null);
    }

    public void preconditionFailed(PreconditionFailedException error, PreconditionContainer.FailOption onFail) {
    }

    public void preconditionErrored(PreconditionErrorException error, PreconditionContainer.ErrorOption onError) {
    }

    public void willRun(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
    }

    public void ran(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
    }

    public void runFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        this.logEvent(changeSet, database, "fail", null);
    }

    public void rollbackFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        this.logEvent(changeSet, database, "fail", null);
    }

    public void markedRan(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        this.logEvent(changeSet, database, "success", null);
    }

    public void markedRanFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception e) {
        this.logEvent(changeSet, database, "fail", null);
    }

    public void logEvent(ChangeSet changeSet, Database database, String outcome, CommandScope commandScope) {
        if (DatabaseChangelogHistoryConfiguration.isHistoryEnabled()) {
            if (database.supportsDatabaseChangeLogHistory()) {
                try {
                    Scope.child(Collections.singletonMap("shouldUpdateRowsAffected", false), () -> {
                        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
                        InsertDatabaseChangeLogHistoryStatement insertStatement = new InsertDatabaseChangeLogHistoryStatement(changeSet, outcome, commandScope, this.CREATED_TABLE, executor instanceof LoggingExecutor);
                        executor.execute((SqlStatement)insertStatement);
                        database.commit();
                    });
                }
                catch (Exception e) {
                    Integer severity = (Integer)DatabaseChangelogHistoryConfiguration.SEVERITY.getCurrentValue();
                    if (severity == 0) {
                        Scope.getCurrentScope().getLog(DatabaseChangelogHistoryChangeExecListener.class).severe("Encountered an exception while recording event in history table.", (Throwable)e);
                    }
                    throw new UnexpectedLiquibaseException((Throwable)e, severity.intValue());
                }
            } else if (!PRINTED_UNSUPPORTED_DATABASE_MESSAGE.getAndSet(true)) {
                Scope.getCurrentScope().getUI().sendMessage("INFO: Unable to enable 'DATABASECHANGELOGHISTORY' functions as support for database " + database.getDatabaseProductName() + " is not yet implemented in Liquibase. Learn more at " + "https://docs.liquibase.com/DATABASECHANGELOGHISTORY");
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseChangelogHistoryChangeExecListener)) {
            return false;
        }
        DatabaseChangelogHistoryChangeExecListener other = (DatabaseChangelogHistoryChangeExecListener)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseChangelogHistoryChangeExecListener;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

