/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks;

import com.datical.liquibase.ext.checks.SqlParseException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import liquibase.Scope;
import liquibase.logging.Logger;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParser;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;

@ThreadSafe
public class JSqlParserCache {
    private static final ConcurrentHashMap<CacheKey, Statements> parsedStatementCache = new ConcurrentHashMap();

    public static Statements parseSql(String sql, boolean withSquareBracketQuotation) throws SqlParseException {
        Statements statement;
        Logger log = Scope.getCurrentScope().getLog(JSqlParserCache.class);
        CacheKey cacheKey = new CacheKey(sql, withSquareBracketQuotation);
        if (parsedStatementCache.containsKey(cacheKey)) {
            log.fine("Cache hit for " + cacheKey);
            return parsedStatementCache.get(cacheKey);
        }
        log.fine("Cache miss for " + cacheKey);
        try {
            statement = CCJSqlParserUtil.parseStatements(sql, parser -> {
                CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(withSquareBracketQuotation);
            });
        }
        catch (JSQLParserException e) {
            throw new SqlParseException(e.getMessage());
        }
        parsedStatementCache.put(cacheKey, statement);
        return statement;
    }

    private static class CacheKey {
        private final String sql;
        private final boolean withSquareBracketQuotation;

        public CacheKey(String sql, boolean withSquareBracketQuotation) {
            this.sql = sql;
            this.withSquareBracketQuotation = withSquareBracketQuotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.withSquareBracketQuotation == cacheKey.withSquareBracketQuotation && this.sql.equals(cacheKey.sql);
        }

        public int hashCode() {
            return Objects.hash(this.sql, this.withSquareBracketQuotation);
        }

        public String toString() {
            return "CacheKey{sql='" + this.sql + '\'' + ", withSquareBracketQuotation=" + this.withSquareBracketQuotation + '}';
        }
    }
}

