/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import liquibase.util.StringUtil;

public class StringGetter
extends AbstractCommandLineValueGetter<String> {
    private final boolean allowEmpty;

    public StringGetter(boolean allowEmpty) {
        super(String.class);
        this.allowEmpty = allowEmpty;
    }

    @Override
    public boolean validate(String input) {
        if (this.allowEmpty) {
            return true;
        }
        return StringUtil.isNotEmpty((String)input);
    }

    @Override
    public String convert(String input) {
        return input;
    }

    @Override
    public String describe() {
        if (this.allowEmpty) {
            return "string";
        }
        return "non-empty string";
    }
}

