/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.SetTableRemarksChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableCommentPatternCheck
extends AbstractLiquibaseDynamicForecastRule {
    private static final String MESSAGE_TEMPLATE = "A match for regular expression <" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + "> was detected in <IDENTIFIER>.";
    private static final String DATABASE_FAILURE_SUFFIX = " Please review the indicated table for the table comment content.";
    private static final String CHANGESET_FAILURE_SUFFIX = " Please review the indicated changeset for the table comment content.";

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getName() {
        return "Table Comment Pattern Check";
    }

    private String getFailureMessage(String messageTemplate, String searchString, ChangeSet changeSet, boolean appendDefaultSuffix) {
        return messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", searchString).replace("<IDENTIFIER>", changeSet.getId()).concat(appendDefaultSuffix ? CHANGESET_FAILURE_SUFFIX : "");
    }

    private String getFailureMessage(String messageTemplate, String searchString, Table table, boolean appendDefaultSuffix) {
        return messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", searchString).replace("<IDENTIFIER>", DatabaseObjectUtils.buildFullyQualifiedName((DatabaseObject)table)).concat(appendDefaultSuffix ? DATABASE_FAILURE_SUFFIX : "");
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    private boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, boolean isRollback) {
        String searchString = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        String message = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.MESSAGE);
        OperatorEnum operator = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        boolean isDefaultMessage = message.equalsIgnoreCase(MESSAGE_TEMPLATE);
        for (Change change : changes) {
            String comments;
            if (change instanceof CreateTableChange) {
                comments = ((CreateTableChange)change).getRemarks();
                if (!this.commentMatchesPattern(operator, searchString, comments)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(message, searchString, changeSet, isDefaultMessage), dynamicRule, isRollback);
                continue;
            }
            if (!(change instanceof SetTableRemarksChange) || !this.commentMatchesPattern(operator, searchString, comments = ((SetTableRemarksChange)change).getRemarks())) continue;
            this.addFailureRuleIteration(changeSet, this.getFailureMessage(message, searchString, changeSet, isDefaultMessage), dynamicRule, isRollback);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        String searchString = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        String message = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.MESSAGE);
        OperatorEnum operator = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        boolean isDefaultMessage = message.equalsIgnoreCase(MESSAGE_TEMPLATE);
        if (databaseObject instanceof Table) {
            String comments = ((Table)databaseObject).getRemarks();
            if (this.commentMatchesPattern(operator, searchString, comments)) {
                this.addFailureRuleIteration(databaseObject, this.getFailureMessage(message, searchString, (Table)databaseObject, isDefaultMessage), (AbstractConfigurableRule)dynamicRule);
            }
        } else {
            this.addNonApplicableRuleIteration(databaseObject, String.format("Object '%s' not applicable for rule '%s'", databaseObject.getName(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
    }

    private boolean commentMatchesPattern(OperatorEnum operator, String searchString, String comments) {
        return operator.matches(searchString, comments, false);
    }

    @Override
    public String getDescription() {
        return "This check triggers when specific user-supplied patterns are found in Table Comments.";
    }

    @Override
    public String getShortName() {
        return "TableCommentPatternCheck";
    }

    @Override
    public int getPriority() {
        return 510;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR, null, null, (Object)OperatorEnum.CONTAINS, false), new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING, null, null, null, false), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, MESSAGE_TEMPLATE, false));
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.MODELED;
    }
}

