/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.ProTagCommandStep;
import com.datical.liquibase.ext.command.RollbackReportGenerator;
import com.datical.liquibase.ext.command.helpers.VisibleReportCommandArguments;
import com.datical.liquibase.ext.reports.ReportArguments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.RollbackCommandStep;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.license.LicenseServiceUtils;

@CommandOverride(override=RollbackCommandStep.class)
public class ProRollbackCommandStep
extends RollbackCommandStep {
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        try {
            super.run(resultsBuilder);
            try {
                LicenseServiceUtils.checkProLicenseAndThrowException((String[])RollbackCommandStep.COMMAND_NAME);
            }
            catch (CommandValidationException cve) {
                ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(VisibleReportCommandArguments.class);
                new RollbackReportGenerator().run(resultsBuilder, reportArguments);
                return;
            }
            String tagToRollBackTo = (String)commandScope.getArgumentValue(TAG_ARG);
            this.removeTagOrphans(commandScope, tagToRollBackTo);
        }
        finally {
            ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(VisibleReportCommandArguments.class);
            new RollbackReportGenerator().run(resultsBuilder, reportArguments);
        }
    }

    private void removeTagOrphans(CommandScope commandScope, String tagToRollBackTo) throws DatabaseException {
        Database database = (Database)commandScope.getDependency(Database.class);
        ArrayList localList = new ArrayList(database.getRanChangeSetList());
        Collections.reverse(localList);
        boolean found = false;
        ArrayList<RanChangeSet> matches = new ArrayList<RanChangeSet>();
        for (RanChangeSet ranChangeSet : localList) {
            if (!ranChangeSet.getId().startsWith("liquibasetagcommand")) continue;
            matches.add(ranChangeSet);
            if (!ranChangeSet.getTag().equals(tagToRollBackTo)) continue;
            found = true;
            break;
        }
        if (found) {
            for (RanChangeSet ranChangeSet : matches) {
                ChangeSet changeSet = new ChangeSet(ranChangeSet.getId(), "liquibasetagcommand", false, false, "liquibasetagcommand", null, null, "jdbc", null, true, ObjectQuotingStrategy.LEGACY, null);
                database.removeRanStatus(changeSet);
                Scope.getCurrentScope().getLog(ProTagCommandStep.class).info("Removed changelog entry for tag " + ranChangeSet.getTag());
            }
        }
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int result = super.getOrder(commandDefinition);
        if (result < 0 && !commandDefinition.getName()[0].equals(RollbackCommandStep.COMMAND_NAME[0])) {
            return result;
        }
        return 1100;
    }

    public List<Class<?>> requiredDependencies() {
        ArrayList deps = new ArrayList(super.requiredDependencies());
        deps.add(VisibleReportCommandArguments.class);
        return deps;
    }
}

